/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.List;
import java.util.UUID;
import net.mezimaru.mastersword.entity.custom.HookshotHookProjectileEntity;
import net.mezimaru.mastersword.entity.custom.HypershotHookProjectileEntity;
import net.mezimaru.mastersword.item.custom.BaseHookshotItem;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.HookshotOwnerS2CPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HypershotItem
extends BaseHookshotItem {
    public HypershotItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        if (!pLevel.f_46443_) {
            ItemStack itemstack = player.m_21120_(pHand);
            if (this.isHookShotActive(player)) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            UUID playerUUID = player.m_20148_();
            HypershotHookProjectileEntity projectile = new HypershotHookProjectileEntity((LivingEntity)player, pLevel);
            Vec3 handPos = projectile.getHookshotHoldPosition(1.0f, player, pHand);
            projectile.m_5602_((Entity)player);
            projectile.m_6034_(handPos.f_82479_, player.m_20188_() - 0.5, handPos.f_82481_);
            this.setProjectileProperties(projectile, itemstack, player);
            player.m_6672_(pHand);
            pLevel.m_7967_((Entity)projectile);
            player.m_36335_().m_41524_((Item)this, 50);
            this.setShotFlag(itemstack, true);
            ModMessages.sendToNearbyClients(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
            ModMessages.sendToPlayer(new HookshotOwnerS2CPacket(projectile.m_19879_(), playerUUID, pHand, player.m_146909_()), (ServerPlayer)player);
        }
        this.playShootSound(pLevel, player);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(pHand));
    }

    @Override
    protected void setProjectileProperties(HookshotHookProjectileEntity projectile, ItemStack itemstack, Player player) {
        projectile.setProperties(itemstack, 50.0, 15.0, player.m_146909_(), player.m_146908_(), 0.0f, 3.5f);
    }

    @Override
    protected ChatFormatting getColorForType(ItemStack stack) {
        return ChatFormatting.RED;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.hypershot.tooltip1").m_130940_(ChatFormatting.ITALIC));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.hypershot.tooltip2").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

