/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.mezimaru.mastersword.events.PetFairyEvents;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.item.client.HylianBottleDarkFairyItemRenderer;
import net.mezimaru.mastersword.item.custom.HylianBottleFairyBaseItem;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HylianBottleDarkFairyItem
extends HylianBottleFairyBaseItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HylianBottleDarkFairyItem(Block block, Item.Properties pProperties) {
        super(block, pProperties);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then("animation.fairy.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int ticks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_8105_(stack) - ticks >= 29) {
                int soundNum = new Random().nextInt(3) + 1;
                if (soundNum == 1) {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BOTTLE1.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
                } else if (soundNum == 2) {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BOTTLE2.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
                } else {
                    level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.BOTTLE3.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
                }
                PetFairyEvents.createPetFairy(player, level, "dark");
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    if (!player.m_36356_(new ItemStack((ItemLike)ModItems.HYLIAN_BOTTLE.get(), 1))) {
                        level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)ModItems.HYLIAN_BOTTLE.get(), 1)));
                    }
                }
                player.m_5810_();
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose USE_FAIRY_BOTTLE_POSE = HumanoidModel.ArmPose.create((String)"UseFairyBottle", (boolean)false, (model, entity, arm) -> {
                float desiredXRot = Mth.m_14036_((float)(-model.f_102808_.f_104203_), (float)-1.2f, (float)1.2f) - 10.0f;
                float desiredYRot = model.f_102808_.f_104204_ - 0.31415927f;
                float zRadians = (float)Math.toRadians(-10.0);
                double v = Math.atan2(Math.sin(zRadians), Math.cos(zRadians));
                float xComp = -((float)v) * desiredXRot;
                float yComp = (float)v * desiredYRot;
                if (arm == HumanoidArm.RIGHT) {
                    model.f_102811_.f_104205_ = -10.0f;
                    model.f_102811_.f_104203_ = xComp;
                    model.f_102811_.f_104204_ = yComp;
                } else {
                    model.f_102812_.f_104205_ = 10.0f;
                    model.f_102812_.f_104203_ = xComp;
                    model.f_102812_.f_104204_ = yComp;
                }
            });
            private HylianBottleDarkFairyItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new HylianBottleDarkFairyItemRenderer();
                }
                return this.renderer;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.m_41619_() && entityLiving.m_6117_() && entityLiving.m_7655_() == hand && entityLiving.m_21212_() > 0) {
                    return USE_FAIRY_BOTTLE_POSE;
                }
                return HumanoidModel.ArmPose.ITEM;
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int direction = arm == HumanoidArm.RIGHT ? 1 : -1;
                this.applyItemArmTransform(poseStack, arm);
                if (swingProcess > 0.0f) {
                    float f = Mth.m_14031_((float)(Mth.m_14116_((float)swingProcess) * (float)Math.PI));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(f * 20.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-f * 20.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(f * 80.0f));
                    return true;
                }
                if (player.m_6117_() && player.m_21211_() == itemInHand) {
                    float timeLeft = (float)itemInHand.m_41779_() - ((float)player.m_21212_() - partialTick + 1.0f);
                    float sin = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
                    poseStack.m_85837_((double)direction * -0.4, (double)(sin * 0.0038f) + 0.5, 0.0);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(direction * 180)));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(direction * 90)));
                    poseStack.m_85841_(1.0f, 0.8f, 0.8f);
                    return true;
                }
                return true;
            }

            private void applyItemArmTransform(PoseStack poseStack, HumanoidArm arm) {
                int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                poseStack.m_252880_((float)i * 0.56f, -0.52f, -0.72f);
            }
        });
    }

    public MutableComponent getName(ItemStack stack) {
        MutableComponent prefix = Component.m_237115_((String)"block.mastersword.hylian_bottle_prefix");
        MutableComponent affix = Component.m_237115_((String)"block.mastersword.hylian_bottle_dark_fairy").m_130940_(ChatFormatting.DARK_RED);
        return prefix.m_7220_((Component)affix);
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.mastersword.hylian_bottle_dark_fairy.tooltip1"));
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.mastersword.hylian_bottle_dark_fairy.tooltip2").m_130940_(ChatFormatting.GRAY));
    }
}

