/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.item.custom;

import java.util.List;
import net.mezimaru.mastersword.client.MagicMeterData;
import net.mezimaru.mastersword.entity.custom.FireRodProjectileEntity;
import net.mezimaru.mastersword.events.MagicMeterEvents;
import net.mezimaru.mastersword.network.ModMessages;
import net.mezimaru.mastersword.network.packet.StopFireRodChargeSoundS2CPacket;
import net.mezimaru.mastersword.sound.ModSounds;
import net.mezimaru.mastersword.util.AbilityCapability;
import net.mezimaru.mastersword.util.AbilityCapabilityProvider;
import net.mezimaru.mastersword.util.IMagicItem;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireRodItem
extends SwordItem
implements IMagicItem {
    public static final ItemCooldowns fireRodCooldown = new ItemCooldowns();
    private int tickCounter = 0;

    public FireRodItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (pAttacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pAttacker;
            pStack.m_220157_(1, pAttacker.m_217043_(), player);
        }
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntityLiving;
            if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
                pStack.m_220157_(2, pEntityLiving.m_217043_(), player);
            }
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (stack.m_41773_() < stack.m_41776_() - 1) {
            return false;
        }
        if (!player.f_19853_.f_46443_) {
            player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.fire_rod_broken"), true);
        }
        return true;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack;
        if (!pPlayer.m_7500_() && (stack = pPlayer.m_21120_(pPlayer.m_7655_())).m_41720_() instanceof FireRodItem) {
            if (stack.m_41773_() < stack.m_41776_() - 1) {
                return true;
            }
            if (!pPlayer.f_19853_.f_46443_) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"message.mastersword.fire_rod_broken"), true);
            }
            return false;
        }
        return false;
    }

    public final int m_8105_(ItemStack stack) {
        return 1200;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
        if (abilityCapability == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (stack.m_41720_() instanceof FireRodItem) {
            if (stack.m_41773_() >= stack.m_41776_() - 1) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (MagicMeterData.getMagicAmount(player) < this.getMagicCost() && !player.m_7500_()) {
                if (!player.f_19853_.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.mastersword.no_magic"), true);
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (fireRodCooldown.m_41519_(stack.m_41720_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(pHand);
            abilityCapability.setFullCharge(false);
            level.m_6269_(null, (Entity)player, (SoundEvent)ModSounds.FIRE_ROD_CHARGE.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            abilityCapability.setPlayingFireChargingSound(true);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(level, player, pHand);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int count) {
        if (!level.f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.m_41720_() instanceof FireRodItem) {
                AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
                if (abilityCapability == null) {
                    return;
                }
                ModMessages.sendToNearbyClients(new StopFireRodChargeSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                ModMessages.sendToPlayer(new StopFireRodChargeSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                abilityCapability.setPlayingFireChargingSound(false);
                this.tickCounter = 0;
                if (abilityCapability.isFireRodCharged()) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    FireRodProjectileEntity fireball = new FireRodProjectileEntity((LivingEntity)player, level);
                    fireball.m_37251_((Entity)player, livingEntity.m_146909_(), livingEntity.m_146908_(), 0.0f, 1.2f, 1.0f);
                    fireball.m_6034_(fireball.m_20185_(), fireball.m_20186_() + 0.5, fireball.m_20189_());
                    level.m_6269_(null, (Entity)player, SoundEvents.f_11874_, SoundSource.PLAYERS, 0.6f, 1.0f);
                    level.m_7967_((Entity)fireball);
                    abilityCapability.setFireRodCharged(false);
                    fireRodCooldown.m_41519_((Item)this);
                    player.m_36335_().m_41524_((Item)this, 80);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        stack.m_220157_(2, livingEntity.m_217043_(), serverPlayer);
                        MagicMeterEvents.removeMagic(this.getMagicCost(), serverPlayer);
                    }
                }
            }
        }
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack stack, int ticks) {
        if (!level.f_46443_ && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (stack.m_41720_() instanceof FireRodItem && player.m_21211_().m_41720_() instanceof FireRodItem) {
                AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
                if (abilityCapability == null) {
                    return;
                }
                ++this.tickCounter;
                if (this.tickCounter >= 20) {
                    int numParticles = 1;
                    Vec3 handPosOffset = player.m_204034_((Item)this);
                    double particleY = player.m_20186_() + handPosOffset.m_7098_() + 1.0;
                    for (int i = 0; i < numParticles; ++i) {
                        double randomX = player.m_20185_() + handPosOffset.m_7096_() + (Math.random() - 0.5) * 1.0;
                        double randomZ = player.m_20189_() + handPosOffset.m_7094_() + (Math.random() - 0.5) * 1.0;
                        ParticleHelper.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123744_, randomX, particleY + Math.random() * 0.1, randomZ, (Math.random() - 0.5) * 0.2, Math.random() * 0.1, (Math.random() - 0.5) * 0.2);
                    }
                    abilityCapability.setFireRodCharged(true);
                }
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityCapability abilityCapability = (AbilityCapability)player.getCapability(AbilityCapabilityProvider.ABILITY_CAPABILITY).orElse(null);
            if (abilityCapability == null) {
                return;
            }
            if (!(player.m_21211_().m_41720_() instanceof FireRodItem)) {
                this.tickCounter = 0;
                abilityCapability.setFireRodCharged(false);
                if (abilityCapability.isPlayingFireChargingSound()) {
                    abilityCapability.setPlayingFireChargingSound(false);
                    if (!level.f_46443_) {
                        ModMessages.sendToNearbyClients(new StopFireRodChargeSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                        ModMessages.sendToPlayer(new StopFireRodChargeSoundS2CPacket(player.m_19879_()), (ServerPlayer)player);
                    }
                }
            }
        }
        super.m_6883_(stack, level, entity, slot, selected);
    }

    public MutableComponent getName(ItemStack stack) {
        MutableComponent itemName = (MutableComponent)super.m_7626_(stack);
        return itemName.m_130940_(ChatFormatting.DARK_RED);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int magicCost = this.getMagicCost();
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.magic_cost").m_7220_((Component)Component.m_237113_((String)String.valueOf(magicCost))).m_130940_(ChatFormatting.DARK_GREEN));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.rod.tooltip1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.mastersword.fire_rod.tooltip1").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public int getMagicCost() {
        return 15;
    }
}

