/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.entity.custom;

import javax.annotation.Nullable;
import net.mezimaru.mastersword.config.MasterSwordCommonConfigs;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.util.FriendlyFireHelper;
import net.mezimaru.mastersword.util.ParticleHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class IceRodProjectileEntity
extends ThrowableProjectile {
    public IceRodProjectileEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public IceRodProjectileEntity(LivingEntity pShooter, Level pLevel) {
        super((EntityType)ModEntities.ICE_ROD_PROJECTILE.get(), pShooter, pLevel);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    protected void m_8097_() {
    }

    protected AABB m_142242_() {
        float width = 1.0f;
        float height = 0.7f;
        float yOffset = -0.7f;
        double minX = this.m_20185_() - (double)(width / 2.0f);
        double minY = this.m_20186_() + (double)yOffset;
        double minZ = this.m_20189_() - (double)(width / 2.0f);
        double maxX = this.m_20185_() + (double)(width / 2.0f);
        double maxY = this.m_20186_() + (double)height + (double)yOffset;
        double maxZ = this.m_20189_() + (double)(width / 2.0f);
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - 2.2f;
    }

    public void m_8119_() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d2 = this.m_20185_() + vec3.f_82479_;
        double d0 = this.m_20186_() + vec3.f_82480_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            this.m_146870_();
            return;
        }
        float f = 0.99f;
        this.m_20256_(vec3.m_82490_((double)f));
        this.m_6034_(d2, d0, d1);
        if (this.f_19797_ >= 5) {
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    @Nullable
    private Player getShooter() {
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            return (Player)owner;
        }
        return null;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity targetEntity = pResult.m_82443_();
        if (!(targetEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)targetEntity;
        Player player = this.getShooter();
        if (player == null) {
            return;
        }
        if (pResult.m_82443_() != this.getShooter() && FriendlyFireHelper.checkFriendlyFire(livingEntity, player)) {
            livingEntity.m_252836_();
            livingEntity.m_6469_(this.f_19853_.m_269111_().m_269104_((Entity)player, (Entity)this), ((Double)MasterSwordCommonConfigs.ICE_ROD_DAMAGE.get()).floatValue());
            this.spawnSnowflakeParticles(livingEntity.m_20191_().m_82399_());
            Vec3 currentMovement = livingEntity.m_20184_();
            double newX = currentMovement.f_82479_ * 0.5;
            double newZ = currentMovement.f_82481_ * 0.5;
            livingEntity.m_20256_(new Vec3(newX, currentMovement.f_82480_, newZ));
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        this.spawnSnowflakeParticles(blockHitResult.m_82450_());
        this.m_146870_();
    }

    private void spawnSnowflakeParticles(Vec3 location) {
        int particleCount = 20;
        for (int i = 0; i < particleCount; ++i) {
            ParticleHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_175821_, location.f_82479_, location.f_82480_, location.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

