/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.custom;

import java.util.List;
import net.mezimaru.mastersword.entity.ModEntities;
import net.mezimaru.mastersword.entity.custom.GoronMerchantEntity;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GoronCallBellBlock
extends Block {
    public GoronCallBellBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.makeShape();
    }

    public VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.40625, (double)0.1343749999999999, (double)0.40625, (double)0.59375, (double)0.2281249999999999, (double)0.59375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.07187500000000002, (double)0.375, (double)0.625, (double)0.1343749999999999, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.359375, (double)0.0015625000000000222, (double)0.359375, (double)0.640625, (double)0.06406250000000002, (double)0.640625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)0.05625000000000002, (double)0.46875, (double)0.53125, (double)0.08750000000000002, (double)0.53125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.484375, (double)0.2281249999999999, (double)0.484375, (double)0.515625, (double)0.2593749999999999, (double)0.515625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.46875, (double)0.2593749999999999, (double)0.46875, (double)0.53125, (double)0.2906249999999999, (double)0.53125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.34375, (double)0.0015625000000000222, (double)0.34375, (double)0.65625, (double)0.03281250000000002, (double)0.65625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Direction playerDirection = pPlayer.m_6350_();
        BlockPos targetBlockPos = pPos.m_5484_(playerDirection, 2);
        if (this.isEmptySpace(pLevel, targetBlockPos)) {
            List merchants = pLevel.m_45976_(GoronMerchantEntity.class, new AABB(targetBlockPos).m_82400_(50.0));
            if (!merchants.isEmpty()) {
                GoronMerchantEntity merchant = (GoronMerchantEntity)((Object)merchants.get(0));
                merchant.m_21573_().m_26519_((double)targetBlockPos.m_123341_(), (double)targetBlockPos.m_123342_() + 0.5, (double)targetBlockPos.m_123343_(), 0.7);
                merchant.setWanderTarget(targetBlockPos);
            } else {
                GoronMerchantEntity newMerchant = (GoronMerchantEntity)((EntityType)ModEntities.GORON_MERCHANT.get()).m_20615_(pLevel);
                if (newMerchant != null) {
                    newMerchant.m_6034_(targetBlockPos.m_123341_(), (double)targetBlockPos.m_123342_() + 0.2, targetBlockPos.m_123343_());
                    pLevel.m_7967_((Entity)newMerchant);
                    newMerchant.setWanderTarget(targetBlockPos);
                }
            }
            pLevel.m_6269_(null, (Entity)pPlayer, (SoundEvent)ModSounds.CALL_BELL_DING.get(), SoundSource.PLAYERS, 1.0f, 0.9f + pPlayer.m_217043_().m_188501_() * 0.2f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean isEmptySpace(Level level, BlockPos pos) {
        return this.isBlockValid(level, pos) && this.isTopBlockAir(level, pos.m_7494_());
    }

    private boolean isBlockValid(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        return state.m_60795_() || this.isNonObstructive(block);
    }

    private boolean isTopBlockAir(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_46859_(pos);
    }

    private boolean isNonObstructive(Block block) {
        return block instanceof CarpetBlock || block instanceof AirBlock || block instanceof GrassBlock || block instanceof VineBlock || block instanceof SnowLayerBlock;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.mastersword.call_bell_block").m_130940_(ChatFormatting.ITALIC));
    }
}

