/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.block.custom;

import net.mezimaru.mastersword.block.custom.CustomCampfireBlock;
import net.mezimaru.mastersword.item.ModItems;
import net.mezimaru.mastersword.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DinCampfireBlock
extends CustomCampfireBlock {
    private static final int COOLDOWN_TICKS = 300;
    private int tickCounterSeconds = 300;

    public DinCampfireBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        pLevel.m_186460_(new BlockPos((Vec3i)pPos), (Block)this, 1);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!level.f_46443_ && heldItem.m_41619_()) {
            if (this.tickCounterSeconds < 300) {
                player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.din_on_cooldown"));
                return InteractionResult.FAIL;
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_() || stack.m_41720_() != ModItems.DINFLAME.get()) continue;
                player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.already_have_din_inventory"));
                return InteractionResult.FAIL;
            }
            Giant giant = (Giant)EntityType.f_20454_.m_20615_(level);
            if (giant != null) {
                giant.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                giant.m_21051_(Attributes.f_22279_).m_22100_(0.25);
                giant.m_21051_(Attributes.f_22278_).m_22100_(1.0);
                giant.m_21051_(Attributes.f_22282_).m_22100_(3.0);
                giant.m_21051_(Attributes.f_22281_).m_22100_(8.0);
                ItemStack helmet = new ItemStack((ItemLike)Items.f_42480_);
                ItemStack chestplate = new ItemStack((ItemLike)Items.f_42481_);
                ItemStack leggings = new ItemStack((ItemLike)Items.f_42482_);
                ItemStack boots = new ItemStack((ItemLike)Items.f_42483_);
                int playerCount = giant.m_9236_().m_45976_(Player.class, giant.m_20191_().m_82400_(50.0)).size();
                int protectionLevel = Math.min(1 + playerCount, 4);
                helmet.m_41663_(Enchantments.f_44965_, protectionLevel);
                chestplate.m_41663_(Enchantments.f_44965_, protectionLevel);
                leggings.m_41663_(Enchantments.f_44965_, protectionLevel);
                boots.m_41663_(Enchantments.f_44965_, protectionLevel);
                giant.m_8061_(EquipmentSlot.HEAD, helmet);
                giant.m_8061_(EquipmentSlot.CHEST, chestplate);
                giant.m_8061_(EquipmentSlot.LEGS, leggings);
                giant.m_8061_(EquipmentSlot.FEET, boots);
                player.m_213846_((Component)Component.m_237115_((String)"message.mastersword.din_giant_spawn"));
                level.m_7967_((Entity)giant);
                level.m_6263_(null, giant.m_20185_(), giant.m_20186_(), giant.m_20189_(), (SoundEvent)ModSounds.BATTLE_SONG_OF_STORMS.get(), SoundSource.RECORDS, 0.7f, 1.0f);
                this.tickCounterSeconds = 0;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(false)), 3);
                level.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        if (this.tickCounterSeconds < 300) {
            ++this.tickCounterSeconds;
            pLevel.m_186460_(pPos, (Block)this, 20);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)f_51227_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }
}

