/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.util;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;

public class BlendUtil {
    public static double blendBiomeEdge(Holder<Biome> currentBiome, Function<BlockPos, Holder<Biome>> biomeGetter, BlockPos origin, int blendRadius, int blendStep) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int size = Math.floorDiv(blendRadius, blendStep);
        for (BlockPos.MutableBlockPos blockPos : BlockPos.m_121935_((BlockPos)BlockPos.f_121853_, (int)size, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            double distToLowCornerSqr;
            int x = origin.m_123341_() + blockPos.m_123341_() * blendStep;
            int z = origin.m_123343_() + blockPos.m_123343_() * blendStep;
            mutableBlockPos.m_122178_(x, origin.m_123342_(), z);
            Holder<Biome> nearbyBiome = biomeGetter.apply((BlockPos)mutableBlockPos);
            if (nearbyBiome == currentBiome || !((distToLowCornerSqr = mutableBlockPos.m_203202_((double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_())) < (double)Mth.m_144944_((int)blendRadius))) continue;
            return distToLowCornerSqr / (double)Mth.m_144944_((int)blendRadius);
        }
        return 1.0;
    }
}

