/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGStructures;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.BWGVillageTemplatePools;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGStructureProcessorLists;

public class BWGTemplatePools {
    public static final Map<ResourceKey<StructureTemplatePool>, TemplatePoolFactory> TEMPLATE_POOL_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<StructureTemplatePool> PRAIRIE_HOUSE = BWGTemplatePools.register("prairie_house", templatePoolFactoryContext -> BWGTemplatePools.createTemplatePool(BWGTemplatePools.getEmptyPool((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BWGStructures.PRAIRIE_HOUSE.m_135782_().toString(), BWGTemplatePools.getProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.PRAIRIE_HOUSE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> ABANDONED_PRAIRIE_HOUSE = BWGTemplatePools.register("abandoned_prairie_house", templatePoolFactoryContext -> BWGTemplatePools.createTemplatePool(BWGTemplatePools.getEmptyPool((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BWGStructures.ABANDONED_PRAIRIE_HOUSE.m_135782_().toString(), BWGTemplatePools.getProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.ABANDONED_PRAIRIE_HOUSE)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> RUGGED_FOSSIL = BWGTemplatePools.register("rugged_fossil", templatePoolFactoryContext -> BWGTemplatePools.createTemplatePool(BWGTemplatePools.getEmptyPool((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BiomesWeveGone.id("fossils/rugged_1").toString(), BWGTemplatePools.getEmptyProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BiomesWeveGone.id("fossils/rugged_2").toString(), BWGTemplatePools.getEmptyProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BiomesWeveGone.id("fossils/rugged_3").toString(), BWGTemplatePools.getEmptyProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BiomesWeveGone.id("fossils/rugged_4").toString(), BWGTemplatePools.getEmptyProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BiomesWeveGone.id("fossils/rugged_5").toString(), BWGTemplatePools.getEmptyProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BiomesWeveGone.id("fossils/rugged_6").toString(), BWGTemplatePools.getEmptyProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext)), (Object)1)), StructureTemplatePool.Projection.TERRAIN_MATCHING));
    public static final ResourceKey<StructureTemplatePool> ASPEN_MANOR_1 = BWGTemplatePools.register("aspen_manor_1", templatePoolFactoryContext -> BWGTemplatePools.createTemplatePool(BWGTemplatePools.getEmptyPool((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BWGStructures.ASPEN_MANOR_1.m_135782_().toString(), BWGTemplatePools.getProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.ASPEN_MANOR)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    public static final ResourceKey<StructureTemplatePool> ASPEN_MANOR_2 = BWGTemplatePools.register("aspen_manor_2", templatePoolFactoryContext -> BWGTemplatePools.createTemplatePool(BWGTemplatePools.getEmptyPool((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext), (List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)BWGStructures.ASPEN_MANOR_2.m_135782_().toString(), BWGTemplatePools.getProcessor((BootstapContext<StructureTemplatePool>)templatePoolFactoryContext, BWGStructureProcessorLists.ASPEN_MANOR)), (Object)1)), StructureTemplatePool.Projection.RIGID));

    private static StructureTemplatePool createTemplatePool(Holder<StructureTemplatePool> fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> rawTemplateFactories, StructureTemplatePool.Projection projection) {
        return new StructureTemplatePool(fallback, rawTemplateFactories, projection);
    }

    private static Holder.Reference<StructureTemplatePool> getEmptyPool(BootstapContext<StructureTemplatePool> context) {
        return BWGTemplatePools.getPool(context, (ResourceKey<StructureTemplatePool>)Pools.f_127186_);
    }

    private static Holder.Reference<StructureTemplatePool> getPool(BootstapContext<StructureTemplatePool> context, ResourceKey<StructureTemplatePool> poolResourceKey) {
        return context.m_255420_(Registries.f_256948_).m_255043_(poolResourceKey);
    }

    private static Holder.Reference<StructureProcessorList> getEmptyProcessor(BootstapContext<StructureTemplatePool> context) {
        return BWGTemplatePools.getProcessor(context, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_);
    }

    private static Holder.Reference<StructureProcessorList> getProcessor(BootstapContext<StructureTemplatePool> context, ResourceKey<StructureProcessorList> processorList) {
        return context.m_255420_(Registries.f_257011_).m_255043_(processorList);
    }

    private static ResourceKey<StructureTemplatePool> register(String id, TemplatePoolFactory factory) {
        ResourceKey templatePoolResourceKey = BiomesWeveGone.key(Registries.f_256948_, id);
        TEMPLATE_POOL_FACTORIES.put(templatePoolResourceKey, factory);
        return templatePoolResourceKey;
    }

    public static void templatePools() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Template Pools");
        BWGVillageTemplatePools.villageTemplatePools();
    }

    @FunctionalInterface
    public static interface TemplatePoolFactory {
        public StructureTemplatePool generate(BootstapContext<StructureTemplatePool> var1);
    }
}

