/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.pumpkinwarden;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.potionstudios.biomeswevegone.tags.BWGItemTags;
import net.potionstudios.biomeswevegone.world.entity.BWGEntityType;
import net.potionstudios.biomeswevegone.world.entity.ai.behavior.PumpkinWardenGoalPackages;
import net.potionstudios.biomeswevegone.world.entity.ai.memory.BWGMemoryModuleType;
import net.potionstudios.biomeswevegone.world.entity.ai.sensing.BWGSensorType;
import net.potionstudios.biomeswevegone.world.entity.ai.village.poi.BWGPoiTypes;
import net.potionstudios.biomeswevegone.world.entity.schedule.BWGSchedule;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.entities.PumpkinBurrowBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PumpkinWarden
extends PathfinderMob
implements GeoEntity,
VariantHolder<Variant> {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private BlockPos jukebox;
    private boolean party;
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(PumpkinWarden.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26359_, (Object)MemoryModuleType.f_26362_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, BWGMemoryModuleType.VISIBLE_PUMPKIN_WARDENS.get(), (Object)MemoryModuleType.f_26366_, (Object)MemoryModuleType.f_26332_, (Object)MemoryModuleType.f_217781_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26374_, (Object)MemoryModuleType.f_26377_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26379_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26323_, MemoryModuleType.f_26325_, MemoryModuleType.f_26326_, BWGMemoryModuleType.HOPPER_BARREL_LOCATION.get()});
    private static final ImmutableList<SensorType<? extends Sensor<? super PumpkinWarden>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26815_, BWGSensorType.NEAREST_PUMPKIN_WARDENS.get(), (Object)SensorType.f_26816_, (Object)SensorType.f_26814_);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<PumpkinWarden, Holder<PoiType>>> POI_MEMORIES = ImmutableMap.of((Object)MemoryModuleType.f_26359_, (pumpkinWarden, holder) -> holder.m_203565_(BWGPoiTypes.PUMPKIN_BURROW), (Object)MemoryModuleType.f_26362_, (pumpkinWarden, holder) -> holder.m_203565_(PoiTypes.f_218061_));
    private static final RawAnimation HIDE_START = RawAnimation.begin().then("animation.pumpkinwarden.hidestart", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation HIDE = RawAnimation.begin().thenLoop("animation.pumpkinwarden.hide");
    private static final RawAnimation HIDE_END = RawAnimation.begin().then("animation.pumpkinwarden.hideend", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation HOLDING_WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_walking");
    private static final RawAnimation HOLDING_IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.holding_idle");
    private static final RawAnimation WALKING = RawAnimation.begin().thenPlay("animation.pumpkinwarden.walking");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.idle");
    private static final RawAnimation WAVE = RawAnimation.begin().thenPlay("animation.pumpkinwarden.wave");

    public PumpkinWarden(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
    }

    @NotNull
    public Brain<PumpkinWarden> m_6274_() {
        return super.m_6274_();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<?> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        Brain brain = super.m_8075_(dynamic);
        this.registerBrainGoals((Brain<PumpkinWarden>)brain);
        return brain;
    }

    private void refreshBrain(ServerLevel serverLevel) {
        Brain<PumpkinWarden> brain = this.m_6274_();
        brain.m_21933_(serverLevel, (LivingEntity)this);
        this.f_20939_ = brain.m_21973_();
        this.registerBrainGoals(this.m_6274_());
    }

    private void registerBrainGoals(Brain<PumpkinWarden> brain) {
        brain.m_21912_(BWGSchedule.PUMPKIN_WARDEN.get());
        brain.m_21900_(Activity.f_37978_, PumpkinWardenGoalPackages.getCorePackage());
        brain.m_21900_(Activity.f_37981_, PumpkinWardenGoalPackages.getPlayPackage());
        brain.m_21900_(Activity.f_37979_, PumpkinWardenGoalPackages.getIdlePackage());
        brain.m_21900_(Activity.f_37980_, PumpkinWardenGoalPackages.getWorkPackage());
        brain.m_21900_(Activity.f_37982_, PumpkinWardenGoalPackages.getRestPackage());
        brain.m_21900_(Activity.f_37984_, PumpkinWardenGoalPackages.getPanicPackage());
        brain.m_21900_(Activity.f_37987_, PumpkinWardenGoalPackages.getHidePackage());
        brain.m_21903_(Activity.f_37983_, PumpkinWardenGoalPackages.getMeetPackage(), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26362_, (Object)MemoryStatus.VALUE_PRESENT)));
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37981_);
        if (this.isHiding()) {
            brain.m_21889_(Activity.f_37987_);
        } else {
            brain.m_21889_(Activity.f_37981_);
        }
        brain.m_21862_(this.m_9236_().m_46468_(), this.m_9236_().m_46467_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)Variant.DEFAULT.getId());
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
        compound.m_128379_("Hiding", this.isHiding());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        this.setHiding(compound.m_128471_("Hiding"));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.refreshBrain(serverLevel);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 48.0);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_6043_() {
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isHiding()) {
            return InteractionResult.FAIL;
        }
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_150930_(BWGBlocks.ROSE.getBlock().m_5456_())) {
            if (player.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1.0, 1.0, 1.0);
                this.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12503_, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
            }
            itemInHand.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).triggerableAnim("hide_start", HIDE_START).triggerableAnim("hide_end", HIDE_END)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    private <E extends GeoAnimatable> PlayState predicate(@NotNull AnimationState<E> event) {
        event.getController().transitionLength(0);
        if (this.isHiding()) {
            if (event.getController().hasAnimationFinished()) {
                return event.setAndContinue(HIDE);
            }
            return PlayState.CONTINUE;
        }
        if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            if (event.isMoving()) {
                return event.setAndContinue(HOLDING_WALKING);
            }
            return event.setAndContinue(HOLDING_IDLE);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALKING);
        }
        if (this.party) {
            return event.setAndContinue(WAVE);
        }
        return event.setAndContinue(IDLE);
    }

    public void m_6818_(@NotNull BlockPos blockPos, boolean partying) {
        this.jukebox = blockPos;
        this.party = partying;
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 10.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("pumpkinwardenBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    protected void m_8022_() {
        this.f_21345_.m_25360_(Goal.Flag.MOVE, this.canMove());
        this.f_21345_.m_25360_(Goal.Flag.JUMP, this.canMove());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, !this.isHiding());
        this.f_21345_.m_25360_(Goal.Flag.TARGET, !this.isHiding());
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(Variant.getSpawnVariant(level.m_213780_()));
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public boolean m_7252_(@NotNull ItemStack stack) {
        return this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && stack.m_204117_(BWGItemTags.PUMPKIN_WARDEN_PICKS_UP);
    }

    public boolean m_21531_() {
        return this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.isHiding();
    }

    public boolean m_7066_(@NotNull ItemStack stack) {
        return stack.m_204117_(BWGItemTags.PUMPKIN_WARDEN_PICKS_UP) && this.m_21531_();
    }

    protected void m_7581_(@NotNull ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        this.m_21008_(InteractionHand.MAIN_HAND, itemStack.m_41777_());
        this.m_21053_(itemEntity);
        this.m_7938_((Entity)itemEntity, itemStack.m_41613_());
        itemStack.m_41774_(itemStack.m_41613_());
        if (itemStack.m_41619_()) {
            itemEntity.m_146870_();
        }
    }

    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return SoundEvents.f_12506_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.5f;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.isHiding() && source.m_276093_(DamageTypes.f_268534_)) {
            amount /= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    protected float m_5632_(float yRot, float animStep) {
        if (this.isHiding()) {
            return 0.0f;
        }
        return super.m_5632_(yRot, animStep);
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (!this.canMove()) {
            travelVector = Vec3.f_82478_;
        }
        super.m_7023_(travelVector);
    }

    public boolean canMove() {
        return !this.isHiding() && !this.party;
    }

    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(HIDING);
    }

    public void hide() {
        if (!this.isHiding()) {
            this.triggerAnim("controller", "hide_start");
            this.setHiding(true);
        }
    }

    public void unhide() {
        if (this.isHiding()) {
            this.triggerAnim("controller", "hide_end");
            this.setHiding(false);
        }
    }

    private void setHiding(boolean flag) {
        this.f_19804_.m_135381_(HIDING, (Object)flag);
    }

    public void setVariant(@NotNull Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getId());
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (this.isHiding()) {
            return this.m_6095_().m_20680_().m_20390_(1.0f, 0.5f);
        }
        return super.m_6972_(pose);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (HIDING.equals(dataAccessor)) {
            this.m_6210_();
        }
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        this.releaseAllPois();
        super.m_6667_(damageSource);
    }

    public boolean m_142066_() {
        return !this.isHiding() && super.m_142066_();
    }

    public void m_5802_(@NotNull BlockPos pos) {
        PumpkinBurrowBlockEntity pumpkinBurrow;
        BlockEntity blockEntity;
        if (this.m_20159_()) {
            this.m_8127_();
        }
        if ((blockEntity = this.m_9236_().m_7702_(pos)) instanceof PumpkinBurrowBlockEntity && (pumpkinBurrow = (PumpkinBurrowBlockEntity)blockEntity).isEmpty()) {
            pumpkinBurrow.addOccupant((LivingEntity)this);
            this.m_21250_(pos);
        }
    }

    public void m_5796_() {
        this.m_20124_(Pose.STANDING);
        this.m_21258_();
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123792_);
        } else if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 5; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particleOption, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    private void releaseAllPois() {
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26359_);
        this.releasePoi((MemoryModuleType<GlobalPos>)MemoryModuleType.f_26362_);
    }

    public void releasePoi(MemoryModuleType<GlobalPos> moduleType) {
        if (this.m_9236_() instanceof ServerLevel) {
            MinecraftServer minecraftServer = ((ServerLevel)this.m_9236_()).m_7654_();
            this.f_20939_.m_21952_(moduleType).ifPresent(globalPos -> {
                ServerLevel serverLevel = minecraftServer.m_129880_(globalPos.m_122640_());
                if (serverLevel != null) {
                    PoiManager poiManager = serverLevel.m_8904_();
                    Optional optional = poiManager.m_27177_(globalPos.m_122646_());
                    BiPredicate<PumpkinWarden, Holder<PoiType>> biPredicate = POI_MEMORIES.get(moduleType);
                    if (optional.isPresent() && biPredicate.test(this, (Holder<PoiType>)((Holder)optional.get()))) {
                        poiManager.m_27154_(globalPos.m_122646_());
                        DebugPackets.m_133719_((ServerLevel)serverLevel, (BlockPos)globalPos.m_122646_());
                    }
                }
            });
        }
    }

    public static boolean villagerToPumpkinWarden(Entity entity, ItemStack stack, Level level) {
        Villager villager;
        if (entity instanceof Villager && (villager = (Villager)entity).m_6162_() && villager.m_21023_(MobEffects.f_19613_) && stack.m_150930_(Items.f_42047_) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PumpkinWarden warden = (PumpkinWarden)BWGEntityType.PUMPKIN_WARDEN.get().m_20615_((Level)serverLevel);
            warden.m_146884_(villager.m_20182_());
            serverLevel.m_7967_((Entity)warden);
            serverLevel.m_5594_(null, villager.m_20183_(), SoundEvents.f_12644_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            villager.m_142687_(Entity.RemovalReason.DISCARDED);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT(0, "default"),
        CHEERY(1, "cheery"),
        FROWNY(2, "frowny"),
        SILLY(3, "silly");

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final String name;
        private final int id;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private static Variant getSpawnVariant(@NotNull RandomSource random) {
            int i = random.m_188503_(100);
            if (i < 25) {
                return DEFAULT;
            }
            if (i < 50) {
                return CHEERY;
            }
            if (i < 75) {
                return SILLY;
            }
            return FROWNY;
        }

        static {
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.m_216439_(Variant::values);
        }
    }
}

