/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.items;

import com.lazrproductions.cuffed.blocks.CellDoor;
import com.lazrproductions.cuffed.blocks.SafeBlock;
import com.lazrproductions.cuffed.blocks.entity.LockableBlockEntity;
import com.lazrproductions.cuffed.blocks.entity.SafeBlockEntity;
import com.lazrproductions.cuffed.init.ModItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyRingItem
extends Item {
    public static final String TAG_BOUND_LOCKS = "BoundLocks";
    public static final String TAG_KEYS = "Keys";

    public KeyRingItem(Item.Properties p) {
        super(p);
    }

    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockState state = level.m_8055_(context.m_8083_());
        if (player != null) {
            ItemStack stack = player.m_21120_(context.m_43724_());
            if (!level.f_46443_ && context.m_43724_() == InteractionHand.MAIN_HAND && KeyRingItem.canBindLock(stack)) {
                if (state.m_60734_() instanceof CellDoor) {
                    LockableBlockEntity lockable;
                    BlockEntity blockEntity;
                    BlockPos bottomPos = context.m_8083_();
                    if (state.m_61143_((Property)CellDoor.f_52730_) == DoubleBlockHalf.UPPER) {
                        bottomPos = bottomPos.m_7495_();
                        state = level.m_8055_(bottomPos);
                    }
                    if ((blockEntity = level.m_7702_(bottomPos)) instanceof LockableBlockEntity && !(lockable = (LockableBlockEntity)blockEntity).hasBeenBound()) {
                        if (KeyRingItem.tryToAddBoundId(player, stack, lockable.getLockId(), "block.cuffed.cell_door")) {
                            lockable.bind();
                            player.m_6278_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY.get())), 1);
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                } else {
                    SafeBlockEntity safe;
                    BlockEntity blockEntity;
                    BlockEntity bottomPos = level.m_7702_(context.m_8083_());
                    if (bottomPos instanceof LockableBlockEntity) {
                        LockableBlockEntity lockable = (LockableBlockEntity)bottomPos;
                        if (!lockable.hasBeenBound() && KeyRingItem.tryToAddBoundId(player, stack, lockable.getLockId(), lockable.getLockName())) {
                            lockable.bind();
                            player.m_6278_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY_RING.get())), 1);
                            return InteractionResult.SUCCESS;
                        }
                    } else if (state.m_60734_() instanceof SafeBlock && (blockEntity = level.m_7702_(context.m_8083_())) instanceof SafeBlockEntity && !(safe = (SafeBlockEntity)blockEntity).hasBeenBound() && KeyRingItem.tryToAddBoundId(player, stack, safe.getLockId(), "block.cuffed.safe")) {
                        safe.bind();
                        player.m_6278_(Stats.f_12982_.m_12902_((Object)((Item)ModItems.KEY_RING.get())), 1);
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public static void addBoundId(ItemStack stack, UUID id) {
        CompoundTag compoundtag = stack.m_41784_();
        ListTag listtag = compoundtag.m_128425_(TAG_BOUND_LOCKS, 9) ? compoundtag.m_128437_(TAG_BOUND_LOCKS, 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        compoundtag1.m_128362_("Id", id);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_(TAG_BOUND_LOCKS, (Tag)listtag);
    }

    public static void addKey(ItemStack stack, ItemStack key) {
        CompoundTag compoundtag = stack.m_41784_();
        ListTag listtag = compoundtag.m_128425_(TAG_BOUND_LOCKS, 9) ? compoundtag.m_128437_(TAG_BOUND_LOCKS, 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        compoundtag1.m_128362_("Id", key.m_41784_().m_128342_("Id"));
        if (key.m_41784_().m_128441_("display")) {
            compoundtag1.m_128359_("Name", key.m_41784_().m_128469_("display").m_128461_("Name"));
        }
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_(TAG_BOUND_LOCKS, (Tag)listtag);
    }

    public static boolean tryToAddBoundId(Player player, ItemStack stack, UUID id, String lockName) {
        if (KeyRingItem.canBindLock(stack) && !KeyRingItem.hasBoundId(stack, id)) {
            KeyRingItem.addBoundId(stack, id);
            if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46145_)) {
                player.m_5661_((Component)Component.m_237115_((String)"item.cuffed.key.info.bound").m_7220_((Component)Component.m_237113_((String)("" + id))), false);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.cuffed.key.info.bound").m_7220_((Component)Component.m_237115_((String)lockName)), false);
            }
            player.m_5496_(SoundEvents.f_11743_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static void removeBoundId(ItemStack stack, UUID id) {
        CompoundTag compoundtag = stack.m_41784_();
        ListTag listtag = compoundtag.m_128425_(TAG_BOUND_LOCKS, 9) ? compoundtag.m_128437_(TAG_BOUND_LOCKS, 10) : new ListTag();
        int index = KeyRingItem.getBoundIdIndex(stack, id);
        if (index >= 0) {
            listtag.remove(index);
        }
        compoundtag.m_128365_(TAG_BOUND_LOCKS, (Tag)listtag);
    }

    public static boolean hasBoundId(ItemStack stack, UUID id) {
        CompoundTag compoundTag = stack.m_41784_();
        if (compoundTag == null) {
            return false;
        }
        if (compoundTag.m_128425_(TAG_BOUND_LOCKS, 9)) {
            ListTag boundPos = compoundTag.m_128437_(TAG_BOUND_LOCKS, 10);
            for (int i = 0; i < boundPos.size(); ++i) {
                if (!boundPos.m_128728_(i).m_128342_("Id").equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getBoundIdIndex(ItemStack stack, UUID id) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag == null) {
            return -1;
        }
        if (compoundTag.m_128425_(TAG_BOUND_LOCKS, 9)) {
            ListTag boundPos = compoundTag.m_128437_(TAG_BOUND_LOCKS, 10);
            for (int i = 0; i < boundPos.size(); ++i) {
                if (boundPos.m_128728_(i).m_128342_("Id") != id) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean canBindLock(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag == null) {
            return true;
        }
        int bindings = 0;
        int keys = 0;
        if (compoundTag.m_128425_(TAG_BOUND_LOCKS, 9)) {
            ListTag boundPos = compoundTag.m_128437_(TAG_BOUND_LOCKS, 10);
            bindings = boundPos.size();
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_(TAG_KEYS)) {
                keys = tag.m_128451_(TAG_KEYS);
            }
        } else {
            return true;
        }
        return bindings < keys;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level pLevel, @Nonnull List<Component> pTooltipComponents, @Nonnull TooltipFlag pIsAdvanced) {
        super.m_7373_(stack, pLevel, pTooltipComponents, pIsAdvanced);
        int amount = 0;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_KEYS)) {
            amount = tag.m_128451_(TAG_KEYS);
        }
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.cuffed.key_ring.description.amount", (Object[])new Object[]{amount}).m_130940_(ChatFormatting.GRAY));
        int bindings = 0;
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_(TAG_BOUND_LOCKS, 9)) {
            ListTag boundPos = compoundTag.m_128437_(TAG_BOUND_LOCKS, 10);
            bindings = boundPos.size();
        }
        if (bindings == amount) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"item.cuffed.key_ring.description.amount", (Object[])new Object[]{bindings}).m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.m_237110_((String)"item.cuffed.key_ring.description.amount", (Object[])new Object[]{bindings}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public ItemStack m_7968_() {
        ItemStack itemstack = new ItemStack((ItemLike)this);
        itemstack.m_41784_().m_128405_(TAG_KEYS, 2);
        return itemstack;
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int num, boolean boo) {
        if (stack.m_41783_() == null) {
            stack.m_41784_().m_128405_(TAG_KEYS, 1);
        }
        super.m_6883_(stack, level, entity, num, boo);
    }
}

