/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.blocks.entity.SafeBlockEntity;
import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModStatistics;
import com.lazrproductions.cuffed.items.KeyItem;
import com.lazrproductions.cuffed.items.KeyRingItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SafeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE_EW = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE_NS = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SafeBlock(BlockBehaviour.Properties p_49046_) {
        super(p_49046_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (state.m_61143_((Property)FACING) == Direction.EAST || state.m_61143_((Property)FACING) == Direction.WEST) {
            return SHAPE_EW;
        }
        return SHAPE_NS;
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_150109_().m_36056_();
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof SafeBlockEntity) {
            SafeBlockEntity safe = (SafeBlockEntity)blockentity;
            boolean isKeyItemAndIsBoundToThis = stack.m_150930_((Item)ModItems.KEY.get()) && KeyItem.isBoundToLock(stack, safe.getLockId());
            boolean isKeyRingItemAndIsBoundToThis = stack.m_150930_((Item)ModItems.KEY_RING.get()) && KeyRingItem.hasBoundId(stack, safe.getLockId());
            boolean isCreativeKey = stack.m_150930_((Item)ModItems.CREATIVE_KEY.get());
            boolean isCreativeBindBreaker = stack.m_150930_((Item)ModItems.CREATIVE_BIND_BREAKER.get());
            boolean isHoldingLockpick = stack.m_150930_((Item)ModItems.LOCKPICK.get());
            if (!isHoldingLockpick) {
                if (isCreativeBindBreaker) {
                    safe.bind();
                    player.m_213846_((Component)Component.m_237110_((String)"item.cuffed.creative_bind_breaker.use", (Object[])new Object[]{Component.m_237115_((String)this.m_7705_())}));
                    return InteractionResult.SUCCESS;
                }
                if (isKeyItemAndIsBoundToThis || isKeyRingItemAndIsBoundToThis || isCreativeKey) {
                    boolean willEndUpLocked = !safe.isLocked();
                    safe.setLocked(willEndUpLocked, level, player, pos);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            } else if (safe.isLocked()) {
                CuffedAPI.Networking.sendLockpickBeginPickingCellDoorPacketToClient((ServerPlayer)player, pos, (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_SPEED_INCREASE_PER_PICK_FOR_BREAKING_SAFES.get(), (Integer)CuffedMod.SERVER_CONFIG.LOCKPICKING_PROGRESS_PER_PICK_FOR_BREAKING_SAFES.get());
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (!safe.isLocked()) {
                player.m_5893_((MenuProvider)((SafeBlockEntity)blockentity));
                player.m_36220_((ResourceLocation)ModStatistics.OPEN_SAFE.get());
                PiglinAi.m_34873_((Player)player, (boolean)true);
            }
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, WATERLOGGED});
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean p_49080_) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, p_49080_);
        }
    }

    public void m_213897_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof SafeBlockEntity) {
            ((SafeBlockEntity)blockentity).recheckOpen();
        }
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new SafeBlockEntity(pos, state);
    }

    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack fromStack) {
        BlockEntity blockentity;
        if (fromStack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof SafeBlockEntity) {
            ((SafeBlockEntity)blockentity).m_58638_(fromStack.m_41786_());
        }
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType path) {
        return false;
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(@Nonnull BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState blockState, @Nonnull Direction direction, @Nonnull BlockState facingState, @Nonnull LevelAccessor levelAccessor, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, facingState, levelAccessor, currentPos, facingPos);
    }
}

