/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronBlock;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronBuildInteractionsEvent;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronInteraction;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.CauldronPlatformHelper;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.consumables.SimpleElixir;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class AlchemistCauldronTile
extends BlockEntity
implements WorldlyContainer {
    public static int MAX_LEVELS = 4;
    public static final Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> INTERACTIONS = AlchemistCauldronTile.newInteractionMap();
    public final NonNullList<ItemStack> inputItems = NonNullList.m_122780_((int)MAX_LEVELS, (Object)ItemStack.f_41583_);
    public final NonNullList<ItemStack> outputItems = NonNullList.m_122780_((int)MAX_LEVELS, (Object)ItemStack.f_41583_);
    private final int[] cooktimes = new int[MAX_LEVELS];

    public AlchemistCauldronTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockRegistry.ALCHEMIST_CAULDRON_TILE.get(), pWorldPosition, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, AlchemistCauldronTile cauldronTile) {
        for (int i = 0; i < cauldronTile.inputItems.size(); ++i) {
            ItemStack itemStack = (ItemStack)cauldronTile.inputItems.get(i);
            if (itemStack.m_41619_() || !cauldronTile.isBoiling(blockState)) {
                cauldronTile.cooktimes[i] = 0;
            } else {
                int n = i;
                cauldronTile.cooktimes[n] = cauldronTile.cooktimes[n] + 1;
            }
            if (cauldronTile.cooktimes[i] <= 100) continue;
            cauldronTile.tryMeltInput(itemStack);
            cauldronTile.cooktimes[i] = 0;
        }
        RandomSource random = Utils.random;
        if (cauldronTile.isBoiling(blockState)) {
            float waterLevel = Mth.m_14179_((float)((float)cauldronTile.getLiquidLevel() / (float)MAX_LEVELS), (float)0.25f, (float)0.9f);
            MagicManager.spawnParticles(level, (ParticleOptions)ParticleTypes.f_123772_, (float)pos.m_123341_() + Mth.m_216283_((RandomSource)random, (float)0.2f, (float)0.8f), (float)pos.m_123342_() + waterLevel, (float)pos.m_123343_() + Mth.m_216283_((RandomSource)random, (float)0.2f, (float)0.8f), 1, 0.0, 0.0, 0.0, 0.0, false);
        }
    }

    public InteractionResult handleUse(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AlchemistCauldronTile) {
            AlchemistCauldronTile tile = (AlchemistCauldronTile)blockEntity;
            ItemStack cauldronInteractionResult = ((AlchemistCauldronInteraction)INTERACTIONS.get((Object)itemStack.m_41720_())).interact(tile, blockState, level, pos, itemStack);
            if (cauldronInteractionResult != null) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)cauldronInteractionResult));
                this.m_6596_();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (this.isValidInput(itemStack)) {
                if (!level.f_46443_) {
                    for (int i = 0; i < this.inputItems.size(); ++i) {
                        ItemStack stack = (ItemStack)this.inputItems.get(i);
                        if (!stack.m_41619_()) continue;
                        ItemStack input = player.m_150110_().f_35937_ ? itemStack.m_41777_() : itemStack.m_41620_(1);
                        input.m_41764_(1);
                        this.inputItems.set(i, (Object)input);
                        player.m_21008_(hand, itemStack);
                        this.m_6596_();
                        break;
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if ((itemStack.m_41619_() || player.m_6047_()) && hand.equals((Object)InteractionHand.MAIN_HAND)) {
                for (ItemStack item : this.inputItems) {
                    if (item.m_41619_()) continue;
                    if (!level.f_46443_) {
                        ItemStack take = item.m_41620_(1);
                        if (player.m_21120_(hand).m_41619_()) {
                            player.m_21008_(hand, take);
                        } else if (!player.m_150109_().m_36054_(take)) {
                            player.m_36176_(take, false);
                        }
                        this.m_6596_();
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected boolean isBaseIngredientPresent(ItemStack stack) {
        return this.isBaseIngredientPresent(stack2 -> CauldronPlatformHelper.itemMatches(stack, stack2), 1);
    }

    protected boolean isBaseIngredientPresent(Predicate<ItemStack> baseIngredientPredicate, int minCount) {
        int count = 0;
        for (ItemStack stack : this.outputItems) {
            if (!baseIngredientPredicate.test(stack) || (count += stack.m_41613_()) < minCount) continue;
            return true;
        }
        return false;
    }

    protected void convertOutput(Predicate<ItemStack> itemToReplace, ItemStack outputItem, int maxCount) {
        int count = 0;
        for (int i = this.outputItems.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.outputItems.get(i);
            if (!itemToReplace.test(stack)) continue;
            this.outputItems.set(i, (Object)outputItem.m_41777_());
            if (++count < maxCount) continue;
            return;
        }
    }

    public boolean addToOutput(ItemStack itemStack) {
        for (int i = 0; i < this.outputItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.outputItems.get(i);
            if (!stack.m_41619_()) continue;
            this.outputItems.set(i, (Object)itemStack);
            return true;
        }
        return false;
    }

    public void tryMeltInput(ItemStack itemStack) {
        ItemStack potentialPotionBase;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        boolean shouldMelt = false;
        boolean success = true;
        if (itemStack.m_150930_((Item)ItemRegistry.SCROLL.get()) && this.isBaseIngredientPresent(CauldronPlatformHelper.IS_WATER, 1)) {
            if ((double)Utils.random.m_188501_() < (Double)ServerConfigs.SCROLL_RECYCLE_CHANCE.get()) {
                ItemStack result = new ItemStack((ItemLike)AlchemistCauldronTile.getInkFromScroll(itemStack));
                this.convertOutput(CauldronPlatformHelper.IS_WATER, result, 1);
            } else {
                success = false;
            }
            shouldMelt = true;
        }
        if (!shouldMelt && this.isBrewable(itemStack)) {
            for (int i = 0; i < this.outputItems.size(); ++i) {
                ItemStack output;
                potentialPotionBase = (ItemStack)this.outputItems.get(i);
                if (potentialPotionBase.m_41619_() || (output = CauldronPlatformHelper.getNonDestructiveBrewingResult(potentialPotionBase, itemStack, this.f_58857_)).m_41619_()) continue;
                this.outputItems.set(i, (Object)output.m_41777_());
                shouldMelt = true;
            }
        }
        if (!shouldMelt && AlchemistCauldronRecipeRegistry.isValidIngredient(itemStack)) {
            for (int i = 0; i < this.outputItems.size(); ++i) {
                AlchemistCauldronRecipe recipe;
                potentialPotionBase = ((ItemStack)this.outputItems.get(i)).m_41777_();
                if (potentialPotionBase.m_41619_() || (recipe = AlchemistCauldronRecipeRegistry.getRecipeForInputs(potentialPotionBase, itemStack)) == null || !this.isBaseIngredientPresent(stack -> CauldronPlatformHelper.itemMatches(stack, potentialPotionBase), recipe.getInput().m_41613_())) continue;
                ItemStack result = recipe.getResult();
                int toConsume = recipe.getInput().m_41613_();
                this.convertOutput(stack -> CauldronPlatformHelper.itemMatches(stack, potentialPotionBase.m_41777_()), ItemStack.f_41583_, toConsume);
                int c = result.m_41613_();
                for (int j = 0; j < c; ++j) {
                    this.addToOutput(result.m_41620_(1));
                }
                shouldMelt = true;
                break;
            }
        }
        if (shouldMelt) {
            itemStack.m_41774_(1);
            this.m_6596_();
            if (success) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.MASTER, 1.0f, 1.0f);
                this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 1);
            } else {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.MASTER, 1.0f, 1.0f);
            }
            this.collapseContainer(this.outputItems);
        }
    }

    public void collapseContainer(NonNullList<ItemStack> container) {
        block0: for (int i = 0; i < container.size(); ++i) {
            if (!((ItemStack)container.get(i)).m_41619_()) continue;
            for (int j = i + 1; j < container.size(); ++j) {
                ItemStack stack = (ItemStack)container.get(j);
                if (stack.m_41619_()) continue;
                container.set(i, (Object)stack);
                container.set(j, (Object)ItemStack.f_41583_);
                continue block0;
            }
        }
    }

    public boolean isValidInput(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ItemRegistry.SCROLL.get()) || this.isBrewable(itemStack) || AlchemistCauldronRecipeRegistry.isValidIngredient(itemStack);
    }

    public boolean isBrewable(ItemStack itemStack) {
        return (Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get() != false && this.f_58857_ != null && CauldronPlatformHelper.isBrewingIngredient(itemStack, this.f_58857_);
    }

    public int getItemWaterColor(ItemStack itemStack) {
        if (this.m_58904_() == null) {
            return 0;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof SimpleElixir) {
            SimpleElixir simpleElixir = (SimpleElixir)item;
            return simpleElixir.getMobEffect().m_19544_().m_19484_();
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_COMMON.get())) {
            return 0x222222;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_UNCOMMON.get())) {
            return 1196800;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_RARE.get())) {
            return 997444;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_EPIC.get())) {
            return 10825376;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.INK_LEGENDARY.get())) {
            return 16559900;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.BLOOD_VIAL.get())) {
            return 5965590;
        }
        if (PotionUtils.m_43579_((ItemStack)itemStack) != Potions.f_43598_) {
            return PotionUtils.m_43575_((ItemStack)itemStack);
        }
        return BiomeColors.m_108811_((BlockAndTintGetter)this.m_58904_(), (BlockPos)this.m_58899_());
    }

    public int getAverageWaterColor() {
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int i = 0;
        for (ItemStack itemStack : this.outputItems) {
            if (itemStack.m_41619_()) continue;
            int k = this.getItemWaterColor(itemStack);
            f += (float)(k >> 16 & 0xFF) / 255.0f;
            f1 += (float)(k >> 8 & 0xFF) / 255.0f;
            f2 += (float)(k >> 0 & 0xFF) / 255.0f;
            ++i;
        }
        f = f / (float)i * 255.0f;
        f1 = f1 / (float)i * 255.0f;
        f2 = f2 / (float)i * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static Item getInkFromScroll(ItemStack scrollStack) {
        Item item = scrollStack.m_41720_();
        if (item instanceof Scroll) {
            Scroll scroll = (Scroll)item;
            ISpellContainer spellContainer = ISpellContainer.get(scrollStack);
            SpellData spellData = spellContainer.getSpellAtIndex(0);
            SpellRarity rarity = spellData.getSpell().getRarity(spellData.getLevel());
            return InkItem.getInkForRarity(rarity);
        }
        return Items.f_41852_;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return false;
    }

    public void m_142466_(CompoundTag pTag) {
        Utils.loadAllItems(pTag, this.inputItems, "Items");
        Utils.loadAllItems(pTag, this.outputItems, "Results");
        super.m_142466_(pTag);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        Utils.saveAllItems(tag, this.inputItems, "Items");
        Utils.saveAllItems(tag, this.outputItems, "Results");
        super.m_183515_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.inputItems.clear();
        this.outputItems.clear();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(this.inputItems.size());
        for (int i = 0; i < this.inputItems.size(); ++i) {
            simpleContainer.m_6836_(i, (ItemStack)this.inputItems.get(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
        }
    }

    protected static ItemStack waterBottle() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
        return stack;
    }

    static Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> newInteractionMap() {
        Object2ObjectOpenHashMap map = (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), o2o -> o2o.defaultReturnValue((tile, blockState, level, pos, itemstack) -> null));
        map.put((Object)Items.f_42447_, (tile, blockState, level, pos, itemstack) -> {
            if (tile.outputItems.stream().anyMatch(ItemStack::m_41619_)) {
                level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < tile.outputItems.size(); ++i) {
                    if (!((ItemStack)tile.outputItems.get(i)).m_41619_()) continue;
                    tile.outputItems.set(i, (Object)AlchemistCauldronTile.waterBottle());
                }
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return null;
        });
        map.put((Object)Items.f_42446_, (tile, blockState, level, pos, itemstack) -> {
            if (tile.outputItems.stream().allMatch(CauldronPlatformHelper.IS_WATER)) {
                tile.outputItems.clear();
                level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return new ItemStack((ItemLike)Items.f_42447_);
            }
            return null;
        });
        map.put((Object)Items.f_42590_, (tile, blockState, level, pos, itemstack) -> {
            for (int i = tile.outputItems.size() - 1; i >= 0; --i) {
                ItemStack stack = (ItemStack)tile.outputItems.get(i);
                if (stack.m_41619_()) continue;
                level.m_5594_(null, pos, CauldronPlatformHelper.IS_WATER.test(stack) ? SoundEvents.f_11770_ : SoundEvents.f_11771_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return stack.m_41620_(1);
            }
            return null;
        });
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, () -> Items.f_42589_);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_COMMON);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_UNCOMMON);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_RARE);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_EPIC);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_LEGENDARY);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.BLOOD_VIAL);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.OAKSKIN_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_OAKSKIN_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.EVASION_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_EVASION_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INVISIBILITY_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_INVISIBILITY_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_HEALING_POTION);
        MinecraftForge.EVENT_BUS.post((Event)new AlchemistCauldronBuildInteractionsEvent((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map));
        return map;
    }

    protected static void createBottleEmptyInteraction(Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> map, Supplier<Item> item) {
        map.put((Object)item.get(), (tile, blockState, level, pos, itemstack) -> {
            for (int i = 0; i < tile.outputItems.size(); ++i) {
                ItemStack stack = (ItemStack)tile.outputItems.get(i);
                if (!stack.m_41619_()) continue;
                ItemStack input = itemstack.m_41777_();
                input.m_41764_(1);
                tile.outputItems.set(i, (Object)input);
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return new ItemStack((ItemLike)Items.f_42590_);
            }
            return null;
        });
    }

    public int[] m_7071_(Direction pSide) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return ((ItemStack)this.inputItems.get(pIndex)).m_41619_() && this.isValidInput(pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public void m_6211_() {
        this.inputItems.clear();
        this.outputItems.clear();
    }

    public int m_6643_() {
        return MAX_LEVELS;
    }

    public boolean m_7983_() {
        return this.inputItems.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.get(pSlot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.f_41583_;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        if (pSlot >= 0 && pSlot <= this.inputItems.size()) {
            this.inputItems.set(pSlot, (Object)pStack);
        }
    }

    public boolean isBoiling(BlockState blockState) {
        return AlchemistCauldronBlock.isLit(blockState) && this.getLiquidLevel() >= 1;
    }

    public int getLiquidLevel() {
        return this.outputItems.stream().filter(itemstack -> !itemstack.m_41619_()).toList().size();
    }
}

