/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.item.util;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.lost_aether.registry.LCItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class CustomHeadArmorItem
extends Item
implements Equipable {
    private static final UUID ARMOR_MODIFIER_HEAD = UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150");
    private final ArmorMaterial material;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public CustomHeadArmorItem(ArmorMaterial material, Item.Properties properties) {
        super(properties.m_41499_(material.m_266425_(ArmorItem.Type.HELMET)));
        this.material = material;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIER_HEAD, "Armor modifier", (double)this.getDefense(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_MODIFIER_HEAD, "Armor toughness", (double)this.getToughness(), AttributeModifier.Operation.ADDITION));
        if (this.getKnockbackResistance() > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(ARMOR_MODIFIER_HEAD, "Armor knockback resistance", (double)this.getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
        }
        this.defaultModifiers = builder.build();
    }

    public int m_6473_() {
        return this.material.m_6646_();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repairItem) {
        return this.material.m_6230_().test(repairItem);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        EquipmentSlot slot = Mob.m_147233_((ItemStack)heldItem);
        ItemStack wornItem = player.m_6844_(slot);
        if (wornItem.m_41619_()) {
            player.m_8061_(slot, heldItem.m_41777_());
            if (!level.m_5776_()) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            heldItem.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)heldItem, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)heldItem);
    }

    public SoundEvent m_150681_() {
        return this.material.m_7344_();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD ? this.defaultModifiers : ImmutableMultimap.of();
    }

    public int getDefense() {
        return this.material.m_7366_(ArmorItem.Type.HELMET);
    }

    public float getToughness() {
        return this.material.m_6651_();
    }

    public float getKnockbackResistance() {
        return this.material.m_6649_();
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public boolean m_8120_(ItemStack pStack) {
        return super.m_8120_(pStack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnchantmentCategory category = enchantment.f_44672_;
        if (category == EnchantmentCategory.ARMOR_HEAD || category == EnchantmentCategory.ARMOR) {
            return category.m_7454_(Items.f_42468_);
        }
        return category.m_7454_(stack.m_41720_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        if (flag.m_257552_()) {
            components.add(LCItems.PLATINUM_DUNGEON_TOOLTIP);
        }
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }
}

