/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.teammoeg.immersiveindustry.util.ItemRecipeProcessResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RecipeSimulateHelper
extends ItemStackHandler {
    int slotOffset = 0;
    private static final BiFunction<Integer, Integer, Integer> sum = (a, b) -> a + b;
    private static ListTag catalyst = new ListTag();

    public RecipeSimulateHelper(ItemStack ... stacks) {
        super(stacks.length);
        for (int i = 0; i < stacks.length; ++i) {
            super.setStackInSlot(i, stacks[i].m_41777_());
        }
    }

    public RecipeSimulateHelper(IItemHandler inv, int minSlot, int maxSlot) {
        super(maxSlot - minSlot);
        this.slotOffset = minSlot;
        for (int i = minSlot; i < maxSlot; ++i) {
            super.setStackInSlot(i, inv.getStackInSlot(i));
        }
    }

    public ItemRecipeProcessResult simulateExtract(List<IngredientWithSize> ling) {
        HashMap<Integer, Integer> slotOps = new HashMap<Integer, Integer>();
        for (IngredientWithSize ing : ling) {
            if (this.simulateExtract(ing, slotOps)) continue;
            return null;
        }
        return new ItemRecipeProcessResult(slotOps);
    }

    public ItemRecipeProcessResult simulateExtract(IngredientWithSize ... ling) {
        HashMap<Integer, Integer> slotOps = new HashMap<Integer, Integer>();
        for (IngredientWithSize ing : ling) {
            if (this.simulateExtract(ing, slotOps)) continue;
            return null;
        }
        return new ItemRecipeProcessResult(slotOps);
    }

    public static List<List<ItemStack>> expand(IngredientWithSize ... ft) {
        ArrayList<List<ItemStack>> li = new ArrayList<List<ItemStack>>(ft.length);
        for (IngredientWithSize t : ft) {
            if (t.getCount() == 0) {
                ItemStack[] iss = t.getBaseIngredient().m_43908_();
                ArrayList<ItemStack> sli = new ArrayList<ItemStack>(iss.length);
                for (ItemStack is : iss) {
                    ItemStack cis = is.m_41777_();
                    cis.m_41698_("display").m_128365_("Lore", (Tag)catalyst);
                    sli.add(cis);
                }
                li.add(sli);
                continue;
            }
            li.add(t.getMatchingStackList());
        }
        return li;
    }

    private boolean simulateExtract(IngredientWithSize ing, Map<Integer, Integer> slotOps) {
        boolean has = false;
        int sizeRemain = ing.getCount();
        for (int i = 0; i < super.getSlots(); ++i) {
            ItemStack inslot = super.getStackInSlot(i);
            if (ing.testIgnoringSize(inslot)) {
                has = true;
                if (sizeRemain > 0) {
                    int extracted = super.extractItem(i, sizeRemain, false).m_41613_();
                    sizeRemain -= extracted;
                    slotOps.merge(i + this.slotOffset, -extracted, sum);
                }
            }
            if (!has || sizeRemain > 0) continue;
            return true;
        }
        return false;
    }

    static {
        catalyst.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"gui.jei.tooltip.immersiveindustry.catalyst"))));
    }
}

