/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import com.teammoeg.immersiveindustry.util.FluidRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.ItemRecipeProcessResult;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public record RecipeProcessResult<T extends Recipe<?>>(T recipe, ItemRecipeProcessResult item, FluidRecipeProcessResult fluid) {
    public RecipeProcessResult(T recipe, ItemRecipeProcessResult item) {
        this(recipe, item, null);
    }

    public RecipeProcessResult(T recipe, FluidRecipeProcessResult fluid) {
        this(recipe, null, fluid);
    }

    public ResourceLocation getId() {
        return this.recipe.m_6423_();
    }

    public void runOperations(IItemHandlerModifiable inventory, IFluidHandler hand) {
        if (this.item != null) {
            this.item.runOperations(inventory);
        }
        if (this.fluid != null) {
            this.fluid.runOperations(hand);
        }
    }

    public void runOperations(IItemHandlerModifiable inventory, IFluidHandler hand, int multiplier) {
        if (this.item != null) {
            this.item.runOperations(inventory, multiplier);
        }
        if (this.fluid != null) {
            this.fluid.runOperations(hand, multiplier);
        }
    }

    public boolean tryRunOperations(IItemHandlerModifiable inventory, IFluidHandler hand) {
        if (hand == null && this.fluid != null || inventory == null && this.item != null) {
            return false;
        }
        if (this.item != null && !this.item.tryRunOperations(inventory)) {
            return false;
        }
        return this.fluid == null || this.fluid.tryRunOperations(hand);
    }

    public int getMaxRuns(IItemHandlerModifiable inventory, IFluidHandler hand) {
        int maxcount = 64;
        if (this.item != null) {
            maxcount = Math.min(maxcount, this.item.getMaxRuns(inventory));
        }
        if (this.fluid != null) {
            maxcount = Math.min(maxcount, this.fluid.getMaxRuns(hand));
        }
        return maxcount;
    }
}

