/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class RecipeHandler<T extends Recipe<?>> {
    private int process;
    private int processMax;
    private ResourceLocation lastRecipe;
    private boolean recipeTested = false;
    private RecipeProcessResult<T> recipeResultCache;
    private final BiFunction<ResourceLocation, T, Integer> getTimes;

    public ResourceLocation getLastRecipe() {
        return this.lastRecipe;
    }

    public RecipeHandler(BiFunction<ResourceLocation, T, Integer> getTimes) {
        this.getTimes = getTimes;
    }

    public void onContainerChanged() {
        this.recipeTested = false;
    }

    public boolean shouldTestRecipe() {
        return !this.recipeTested;
    }

    public boolean setRecipe(RecipeProcessResult<T> recipeObj) {
        this.recipeResultCache = recipeObj;
        boolean res = false;
        if (recipeObj != null) {
            if (this.processMax == 0 || !recipeObj.getId().equals((Object)this.lastRecipe)) {
                this.process = this.processMax = this.getTimes.apply(this.lastRecipe, (ResourceLocation)recipeObj.recipe()).intValue();
                this.lastRecipe = recipeObj.getId();
                res = true;
            }
        } else {
            this.processMax = 0;
            this.process = 0;
            this.lastRecipe = null;
            res = true;
        }
        this.recipeTested = true;
        return res;
    }

    public RecipeProcessResult<T> getRecipeResultCache() {
        return this.recipeResultCache;
    }

    public boolean shouldTickProcess() {
        return this.processMax > 0;
    }

    public boolean tickProcess(int num) {
        if (this.processMax > 0 && this.process > 0) {
            this.process -= num;
            if (this.process <= 0) {
                this.process = 0;
                this.recipeTested = false;
            }
            return true;
        }
        return false;
    }

    public boolean isRecipeFinished() {
        return this.processMax > 0 && this.process <= 0;
    }

    public void endProcess() {
        this.recipeResultCache = null;
        this.processMax = 0;
        this.process = 0;
        this.recipeTested = false;
    }

    public void resetProgress() {
        this.process = this.processMax;
    }

    public void readCustomNBT(CompoundTag nbt, boolean isClient) {
        this.process = nbt.m_128451_("process");
        this.processMax = nbt.m_128451_("processMax");
        if (!isClient) {
            this.recipeResultCache = null;
            this.lastRecipe = nbt.m_128441_("lastRecipe") ? new ResourceLocation(nbt.m_128461_("lastRecipe")) : null;
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean isClient) {
        nbt.m_128405_("process", this.process);
        nbt.m_128405_("processMax", this.processMax);
        if (!isClient && this.lastRecipe != null) {
            nbt.m_128359_("lastRecipe", this.lastRecipe.toString());
        }
    }

    public int getProcess() {
        return this.process;
    }

    public int getProcessMax() {
        return this.processMax;
    }

    public int getFinishedProgress() {
        return this.processMax - this.process;
    }

    public float getProgressRatio() {
        if (this.processMax <= 0) {
            return 0.0f;
        }
        return (float)this.getFinishedProgress() * 1.0f / (float)this.processMax;
    }

    public IItemHandlerModifiable createItemHanlderWrapper(final IItemHandlerModifiable wrapped, final int inputSlots) {
        return new IItemHandlerModifiable(){

            public int getSlots() {
                return wrapped.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return wrapped.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                int incount = stack.m_41613_();
                ItemStack out = wrapped.insertItem(slot, stack, simulate);
                if (!simulate && slot < inputSlots && out.m_41613_() != incount) {
                    RecipeHandler.this.onContainerChanged();
                }
                return out;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack out = wrapped.extractItem(slot, amount, simulate);
                if (!simulate && slot < inputSlots && !out.m_41619_()) {
                    RecipeHandler.this.onContainerChanged();
                }
                return out;
            }

            public int getSlotLimit(int slot) {
                return wrapped.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return wrapped.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                wrapped.setStackInSlot(slot, stack);
            }
        };
    }
}

