/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import com.teammoeg.immersiveindustry.util.RangedInputWrapper;
import java.util.function.BiPredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class RangedCheckedInputWrapper
extends RangedInputWrapper {
    BiPredicate<Integer, ItemStack> check;

    public RangedCheckedInputWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive, BiPredicate<Integer, ItemStack> check) {
        super(compose, minSlot, maxSlotExclusive);
        this.check = check;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.check.test(slot, stack) && super.isItemValid(slot, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }
}

