/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class MultipleTankHandler
implements IFluidHandler {
    final int numtanks;
    final FluidTank[] tanks;

    public MultipleTankHandler(int numtanks, int capacity) {
        this.numtanks = numtanks;
        this.tanks = new FluidTank[numtanks];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(capacity);
        }
    }

    public MultipleTankHandler(FluidTank[] tanks) {
        this.numtanks = tanks.length;
        this.tanks = tanks;
    }

    public int getTanks() {
        return this.numtanks;
    }

    public FluidTank getTank(int tank) {
        return this.tanks[tank];
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank >= this.numtanks) {
            return FluidStack.EMPTY;
        }
        return this.tanks[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        if (tank >= this.numtanks) {
            return 0;
        }
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (tank >= this.numtanks) {
            return false;
        }
        return this.tanks[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int maxFill = resource.getAmount();
        for (int i = 0; i < this.tanks.length; ++i) {
            int amount = this.tanks[i].fill(resource, action);
            resource.shrink(amount);
            if (!resource.isEmpty()) continue;
            return amount;
        }
        return maxFill - resource.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack out = FluidStack.EMPTY;
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidStack drained = this.tanks[i].drain(resource, action);
            if (drained.isEmpty()) continue;
            if (out.isEmpty()) {
                out = drained;
            } else {
                out.setAmount(out.getAmount() + drained.getAmount());
            }
            if (out.getAmount() >= resource.getAmount()) break;
        }
        return out;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack filter = FluidStack.EMPTY;
        FluidStack out = FluidStack.EMPTY;
        for (int i = 0; i < this.tanks.length; ++i) {
            if (filter.isEmpty()) {
                drained = this.tanks[i].drain(maxDrain, action);
                if (!drained.isEmpty()) {
                    out = drained;
                    filter = new FluidStack(out, maxDrain - out.getAmount());
                }
            } else {
                drained = this.tanks[i].drain(filter, action);
                if (!drained.isEmpty()) {
                    out.setAmount(out.getAmount() + drained.getAmount());
                    filter.shrink(drained.getAmount());
                }
            }
            if (out.getAmount() >= maxDrain) break;
        }
        return out;
    }
}

