/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;

public class IdRegistry<T> {
    private List<T> fromPacket = new ArrayList<T>();
    private Map<T, Integer> types = new IdentityHashMap<T, Integer>();

    public T read(FriendlyByteBuf pb) {
        return this.get(pb.readByte());
    }

    public T register(T from) {
        if (this.types.containsKey(from)) {
            return from;
        }
        int id = this.fromPacket.size();
        this.fromPacket.add(from);
        this.types.put(from, id);
        return from;
    }

    public int getId(T obj) {
        Integer dat = this.types.get(obj.getClass());
        if (dat == null) {
            dat = 0;
        }
        return dat;
    }

    public T get(int id) {
        if (id < 0 || id >= this.fromPacket.size()) {
            throw new IllegalArgumentException("Packet Error");
        }
        return this.fromPacket.get(id);
    }

    public void write(FriendlyByteBuf pb, T obj) {
        pb.writeByte(this.getId(obj));
    }
}

