/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import com.teammoeg.immersiveindustry.util.AccessableInfoArea;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class IIContainerScreen<C extends AbstractContainerMenu>
extends AbstractContainerScreen<C> {
    protected final List<InfoArea> infoAreas = new ArrayList<InfoArea>();
    protected final ResourceLocation background;

    public IIContainerScreen(C inventorySlotsIn, Inventory inv, Component title, ResourceLocation background) {
        super(inventorySlotsIn, inv, title);
        this.background = background;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.infoAreas.clear();
        this.makeInfoAreas();
        this.f_97731_ = this.f_97727_ - 91;
    }

    protected void addInfoArea(InfoArea area) {
        this.infoAreas.add(area);
    }

    protected void makeInfoAreas() {
    }

    public AccessableInfoArea getHoveredStack(int mouseX, int mouseY) {
        for (InfoArea ia : this.infoAreas) {
            AccessableInfoArea aia;
            if (!(ia instanceof AccessableInfoArea) || !(aia = (AccessableInfoArea)ia).getArea().m_110087_(mouseX, mouseY)) continue;
            return aia;
        }
        return null;
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, -557004, true);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, -557004, true);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        ArrayList tooltip = new ArrayList();
        for (InfoArea area : this.infoAreas) {
            area.fillTooltip(mouseX, mouseY, tooltip);
        }
        for (GuiEventListener w : this.m_6702_()) {
            if (!w.m_5953_((double)mouseX, (double)mouseY) || !(w instanceof ITooltipWidget)) continue;
            ITooltipWidget ttw = (ITooltipWidget)w;
            ttw.gatherTooltip(mouseX, mouseY, tooltip);
        }
        this.gatherAdditionalTooltips(mouseX, mouseY, tooltip::add, t -> tooltip.add(TextUtils.applyFormat((Component)t, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY})));
        if (!tooltip.isEmpty()) {
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        } else {
            this.m_280072_(graphics, mouseX, mouseY);
        }
    }

    protected boolean isMouseIn(int mouseX, int mouseY, int x, int y, int w, int h) {
        return mouseX >= this.f_97735_ + x && mouseY >= this.f_97736_ + y && mouseX < this.f_97735_ + x + w && mouseY < this.f_97736_ + y + h;
    }

    protected final void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawBackgroundTexture(graphics);
        this.drawContainerBackgroundPre(graphics, partialTicks, x, y);
        for (InfoArea area : this.infoAreas) {
            area.draw(graphics);
        }
    }

    protected void drawBackgroundTexture(GuiGraphics graphics) {
        graphics.m_280218_(this.background, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void drawContainerBackgroundPre(GuiGraphics graphics, float partialTicks, int x, int y) {
    }

    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
    }
}

