/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import com.teammoeg.immersiveindustry.util.IIBaseContainer;
import com.teammoeg.immersiveindustry.util.IdRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraftforge.fluids.FluidStack;

public class IIContainerData {
    public static final IdRegistry<OtherDataSlotEncoder<?>> encoders = new IdRegistry();
    public static final DataSlotConverter<Integer> SLOT_INT = new DataSlotConverter<Integer>(){

        @Override
        public Integer apply(int value) {
            return value;
        }

        @Override
        public int apply(Integer t) {
            return t;
        }

        @Override
        public Integer getDefault() {
            return 0;
        }
    };
    public static final DataSlotConverter<Boolean> SLOT_BOOL = new DataSlotConverter<Boolean>(){

        @Override
        public Boolean apply(int value) {
            return value != 0;
        }

        @Override
        public int apply(Boolean t) {
            return t != false ? 1 : 0;
        }

        @Override
        public Boolean getDefault() {
            return false;
        }
    };
    public static final DataSlotConverter<Float> SLOT_FIXED = new DataSlotConverter<Float>(){

        @Override
        public Float apply(int value) {
            return Float.valueOf((float)value / 100.0f);
        }

        @Override
        public int apply(Float t) {
            return (int)((t == null ? 0.0f : t.floatValue()) * 100.0f);
        }

        @Override
        public Float getDefault() {
            return Float.valueOf(0.0f);
        }
    };
    public static final DataSlotConverter<Float> SLOT_FLOAT = new DataSlotConverter<Float>(){

        @Override
        public Float apply(int value) {
            return Float.valueOf(Float.intBitsToFloat(value));
        }

        @Override
        public int apply(Float a) {
            return Float.floatToRawIntBits(a.floatValue());
        }

        @Override
        public Float getDefault() {
            return Float.valueOf(0.0f);
        }
    };
    public static final MultipleDataSlotConverter<Long> SLOT_LONG = new MultipleDataSlotConverter<Long>(){

        @Override
        public void encode(Long a, int[] values) {
            values[0] = (int)(a >> 32);
            values[1] = (int)a.longValue();
        }

        @Override
        public Long decode(int[] values) {
            return (long)values[0] << 32 | (long)values[1] & 0xFFFFFFFFL;
        }

        @Override
        public int getCount() {
            return 2;
        }

        @Override
        public Long getDefault() {
            return 0L;
        }

        @Override
        public boolean isSame(Long data, Long data2) {
            return Objects.equals(data, data2);
        }
    };
    public static final MultipleDataSlotConverter<BlockPos> SLOT_BLOCKPOS = new MultipleDataSlotConverter<BlockPos>(){

        @Override
        public void encode(BlockPos a, int[] values) {
            long v = a.m_121878_();
            values[0] = (int)(v >> 32);
            values[1] = (int)v;
        }

        @Override
        public BlockPos decode(int[] values) {
            return BlockPos.m_122022_((long)((long)values[0] << 32 | (long)values[1] & 0xFFFFFFFFL));
        }

        @Override
        public int getCount() {
            return 2;
        }

        @Override
        public BlockPos getDefault() {
            return BlockPos.f_121853_;
        }

        @Override
        public boolean isSame(BlockPos data, BlockPos data2) {
            return Objects.equals(data, data2);
        }
    };
    public static final MultipleDataSlotConverter<Vec3i> SLOT_V3I = new MultipleDataSlotConverter<Vec3i>(){

        @Override
        public void encode(Vec3i a, int[] values) {
            values[0] = a.m_123341_();
            values[1] = a.m_123342_();
            values[2] = a.m_123343_();
        }

        @Override
        public Vec3i decode(int[] values) {
            return new Vec3i(values[0], values[1], values[2]);
        }

        @Override
        public int getCount() {
            return 3;
        }

        @Override
        public Vec3i getDefault() {
            return Vec3i.f_123288_;
        }

        @Override
        public boolean isSame(Vec3i data, Vec3i data2) {
            return Objects.equals(data, data2);
        }
    };
    public static final OtherDataSlotEncoder<FluidStack> SLOT_TANK = new OtherDataSlotEncoder<FluidStack>(){

        @Override
        public FluidStack read(FriendlyByteBuf network) {
            return FluidStack.readFromPacket((FriendlyByteBuf)network);
        }

        @Override
        public void write(FriendlyByteBuf network, FluidStack data) {
            data.writeToPacket(network);
        }

        @Override
        public FluidStack copy(FluidStack data) {
            return data.copy();
        }

        @Override
        public FluidStack getDefault() {
            return FluidStack.EMPTY;
        }

        @Override
        public boolean isSame(FluidStack data, FluidStack data2) {
            if (data == null) {
                return data == data2;
            }
            if (data2 == null) {
                return false;
            }
            return data.isFluidStackIdentical(data2);
        }
    };

    public static <T> CustomDataSlot<T> create(IIBaseContainer container, DataSlotConverter<T> type) {
        SingleDataSlot<T> slot = new SingleDataSlot<T>(type);
        container.m_38895_(slot);
        return slot;
    }

    public static <T> CustomDataSlot<T> create(IIBaseContainer container, MultipleDataSlotConverter<T> type) {
        MultiDataSlot<T> slot = new MultiDataSlot<T>(type);
        container.m_38884_(slot);
        return slot;
    }

    public static <T> CustomDataSlot<T> create(IIBaseContainer container, OtherDataSlotEncoder<T> type) {
        OtherDataSlot<T> slot = new OtherDataSlot<T>(type);
        container.addDataSlot(slot);
        return slot;
    }

    static {
        encoders.register(SLOT_TANK);
    }

    private static class SingleDataSlot<T>
    extends DataSlot
    implements CustomDataSlot<T> {
        T value;
        DataSlotConverter<T> conv;
        Supplier<T> getter;
        Consumer<T> setter;

        public SingleDataSlot(DataSlotConverter<T> conv) {
            this.conv = conv;
            this.value = conv.getDefault();
        }

        public int m_6501_() {
            return this.conv.apply(this.getter != null ? this.getter.get() : this.value);
        }

        public void m_6422_(int pValue) {
            this.setValue(this.conv.apply(pValue));
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public void setValue(T t) {
            if (this.setter != null) {
                this.setter.accept(t);
            }
            this.value = t;
        }

        @Override
        public void bind(Supplier<T> getter) {
            this.getter = getter;
        }

        @Override
        public void bind(Supplier<T> getter, Consumer<T> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void bind(Consumer<T> setter) {
            this.setter = setter;
        }
    }

    public static interface DataSlotConverter<A>
    extends IntFunction<A> {
        public int apply(A var1);

        public A getDefault();

        default public CustomDataSlot<A> create(IIBaseContainer container) {
            return IIContainerData.create(container, this);
        }
    }

    private static class MultiDataSlot<T>
    implements ContainerData,
    CustomDataSlot<T> {
        T value;
        T lastValue;
        int[] values;
        MultipleDataSlotConverter<T> conv;
        Supplier<T> getter;
        Consumer<T> setter;

        public MultiDataSlot(MultipleDataSlotConverter<T> conv) {
            this.conv = conv;
            this.value = conv.getDefault();
            this.values = new int[conv.getCount()];
        }

        private void updateIfNeeded() {
            if (!this.conv.isSame(this.value, this.lastValue)) {
                this.conv.encode(this.value, this.values);
                this.lastValue = this.value;
            }
        }

        public int m_6413_(int pIndex) {
            if (this.getter != null) {
                this.value = this.getter.get();
            }
            this.updateIfNeeded();
            return this.values[pIndex];
        }

        public void m_8050_(int pIndex, int pValue) {
            this.values[pIndex] = pValue;
            this.lastValue = this.conv.decode(this.values);
            this.value = this.lastValue;
        }

        public int m_6499_() {
            return this.conv.getCount();
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public void setValue(T t) {
            if (this.setter != null) {
                this.setter.accept(t);
            }
            this.value = t;
        }

        @Override
        public void bind(Supplier<T> getter) {
            this.getter = getter;
        }

        @Override
        public void bind(Supplier<T> getter, Consumer<T> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void bind(Consumer<T> setter) {
            this.setter = setter;
        }
    }

    public static interface MultipleDataSlotConverter<A> {
        public void encode(A var1, int[] var2);

        public A decode(int[] var1);

        public int getCount();

        public A getDefault();

        public boolean isSame(A var1, A var2);

        default public CustomDataSlot<A> create(IIBaseContainer container) {
            return IIContainerData.create(container, this);
        }
    }

    private static class OtherDataSlot<T>
    implements CustomDataSlot<T>,
    SyncableDataSlot<T> {
        T value;
        T oldValue;
        OtherDataSlotEncoder<T> conv;
        Supplier<T> getter;
        Consumer<T> setter;

        public OtherDataSlot(OtherDataSlotEncoder<T> conv) {
            this.conv = conv;
            this.value = conv.getDefault();
            this.oldValue = conv.getDefault();
        }

        @Override
        public T getValue() {
            return this.getter != null ? this.getter.get() : this.value;
        }

        @Override
        public void setValue(T t) {
            if (this.setter != null) {
                this.setter.accept(t);
            }
            this.value = t;
        }

        @Override
        public void bind(Supplier<T> getter) {
            this.getter = getter;
        }

        @Override
        public void bind(Supplier<T> getter, Consumer<T> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void bind(Consumer<T> setter) {
            this.setter = setter;
        }

        @Override
        public boolean checkForUpdate() {
            T curval = this.getValue();
            if (!this.conv.isSame(this.oldValue, curval)) {
                this.oldValue = this.conv.copy(curval);
                return true;
            }
            return false;
        }

        @Override
        public OtherDataSlotEncoder<T> getConverter() {
            return this.conv;
        }
    }

    public static interface OtherDataSlotEncoder<A> {
        public A read(FriendlyByteBuf var1);

        public void write(FriendlyByteBuf var1, A var2);

        public A copy(A var1);

        public A getDefault();

        public boolean isSame(A var1, A var2);

        default public CustomDataSlot<A> create(IIBaseContainer container) {
            return IIContainerData.create(container, this);
        }
    }

    public static interface SyncableDataSlot<T> {
        public boolean checkForUpdate();

        public void setValue(T var1);

        public T getValue();

        public OtherDataSlotEncoder<T> getConverter();
    }

    public static interface CustomDataSlot<T> {
        public T getValue();

        public void setValue(T var1);

        public void bind(Supplier<T> var1);

        public void bind(Consumer<T> var1);

        public void bind(Supplier<T> var1, Consumer<T> var2);

        default public Supplier<T> asSupplier() {
            return () -> this.getValue();
        }

        default public <R> Supplier<R> map(Function<T, R> mapper) {
            return () -> mapper.apply(this.getValue());
        }
    }
}

