/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import com.teammoeg.immersiveindustry.IINetwork;
import com.teammoeg.immersiveindustry.network.IIContainerDataSync;
import com.teammoeg.immersiveindustry.network.IIContainerOperation;
import com.teammoeg.immersiveindustry.util.IIContainerData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;

public abstract class IIBaseContainer
extends AbstractContainerMenu {
    protected final int INV_START;
    protected static final int INV_SIZE = 36;
    protected static final int INV_QUICK = 27;
    protected Predicate<Player> validator;
    protected Lazy<Function<ItemStack, Boolean>> moveFunction = Lazy.of(() -> this.defineQuickMoveStack().build(this));
    protected List<IIContainerData.SyncableDataSlot<?>> specialDataSlots = new ArrayList();
    private Player player;

    public IIBaseContainer(MenuType<?> pMenuType, int pContainerId, Player player, int inv_start) {
        super(pMenuType, pContainerId);
        this.INV_START = inv_start;
        this.player = player;
    }

    protected void addPlayerInventory(Inventory inv, int dx, int dy, int quickBarY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, dx + j * 18, dy + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, dx + i * 18, quickBarY));
        }
    }

    public QuickMoveStackBuilder defineQuickMoveStack() {
        return QuickMoveStackBuilder.first(0, this.INV_START);
    }

    public boolean quickMoveIn(ItemStack slotStack) {
        return (Boolean)((Function)this.moveFunction.get()).apply(slotStack);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index < this.INV_START) {
                if (!this.m_38903_(slotStack, this.INV_START, 36 + this.INV_START, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, itemStack);
            } else if (index >= this.INV_START ? !this.quickMoveIn(slotStack) && (index < 27 + this.INV_START ? !this.m_38903_(slotStack, 27 + this.INV_START, 36 + this.INV_START, false) : index < 36 + this.INV_START && !this.m_38903_(slotStack, this.INV_START, 27 + this.INV_START, false)) : !this.m_38903_(slotStack, this.INV_START, 36 + this.INV_START, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemStack;
    }

    public boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_()) {
            while (!pStack.m_41619_() && !(pReverseDirection ? i < pStartIndex : i >= pEndIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (slot.m_5857_(pStack) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), pStack.m_41741_()))) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(pStack)) {
                    if (pStack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(pStack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void receiveMessage(short btnId, int state) {
    }

    public void sendMessage(int btnId, int state) {
        IINetwork.sendToServer(new IIContainerOperation(this.f_38840_, (short)btnId, state));
    }

    public void sendMessage(int btnId, boolean state) {
        IINetwork.sendToServer(new IIContainerOperation(this.f_38840_, (short)btnId, state ? 1 : 0));
    }

    public void sendMessage(int btnId, float state) {
        IINetwork.sendToServer(new IIContainerOperation(this.f_38840_, (short)btnId, Float.floatToRawIntBits(state)));
    }

    public DataSlot m_38895_(DataSlot pIntValue) {
        return super.m_38895_(pIntValue);
    }

    public void m_38884_(ContainerData pArray) {
        super.m_38884_(pArray);
    }

    public void addDataSlot(IIContainerData.SyncableDataSlot<?> slot) {
        this.specialDataSlots.add(slot);
    }

    public void processPacket(IIContainerDataSync packet) {
        packet.forEach((i, o) -> this.specialDataSlots.get((int)i).setValue(o));
    }

    public void m_38946_() {
        super.m_38946_();
        IIContainerDataSync packet = new IIContainerDataSync();
        for (int i = 0; i < this.specialDataSlots.size(); ++i) {
            IIContainerData.SyncableDataSlot<?> slot = this.specialDataSlots.get(i);
            if (!slot.checkForUpdate()) continue;
            packet.add(i, slot.getConverter(), slot.getValue());
        }
        if (packet.hasData() && this.player != null) {
            IINetwork.sendPlayer((ServerPlayer)this.player, packet);
        }
    }

    public boolean m_6875_(Player pPlayer) {
        if (this.validator == null) {
            return true;
        }
        return this.validator.test(pPlayer);
    }

    public static class QuickMoveStackBuilder {
        List<Range> ranges = new ArrayList<Range>();

        private QuickMoveStackBuilder() {
        }

        public static QuickMoveStackBuilder begin() {
            return new QuickMoveStackBuilder();
        }

        public static QuickMoveStackBuilder first(int slot) {
            return QuickMoveStackBuilder.begin().then(slot);
        }

        public static QuickMoveStackBuilder first(int beginInclusive, int endExclusive) {
            return QuickMoveStackBuilder.begin().then(beginInclusive, endExclusive);
        }

        public QuickMoveStackBuilder then(int slot) {
            this.ranges.add(new Range(slot));
            return this;
        }

        public QuickMoveStackBuilder then(int beginInclusive, int endExclusive) {
            this.ranges.add(new Range(beginInclusive, endExclusive, false));
            return this;
        }

        public QuickMoveStackBuilder then(int beginInclusive, int endExclusive, boolean reversed) {
            this.ranges.add(new Range(beginInclusive, endExclusive, reversed));
            return this;
        }

        public Function<ItemStack, Boolean> build(IIBaseContainer t) {
            return i -> {
                for (Range r : this.ranges) {
                    if (!t.m_38903_((ItemStack)i, r.start(), r.end(), r.reverse())) continue;
                    return true;
                }
                return false;
            };
        }

        private record Range(int start, int end, boolean reverse) {
            private Range(int slot) {
                this(slot, slot + 1, false);
            }
        }
    }

    public static class Validator
    implements Predicate<Player> {
        Vec3 initial;
        int distsqr;

        public Validator(BlockPos initial, int distance) {
            this.initial = Vec3.m_82512_((Vec3i)initial);
            this.distsqr = distance * distance;
        }

        @Override
        public boolean test(Player t) {
            return t.m_20182_().m_82557_(this.initial) <= (double)this.distsqr;
        }

        public Predicate<Player> and(BooleanSupplier supp) {
            return this.and((? super T t) -> supp.getAsBoolean());
        }
    }
}

