/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public record FluidRecipeProcessResult(List<FluidStack> operations) {
    public void runOperations(IFluidHandler inventory) {
        this.runOperations(inventory, 1);
    }

    public void runOperations(IFluidHandler inventory, int multiplier) {
        if (this.operations != null) {
            for (FluidStack i : this.operations) {
                inventory.drain(new FluidStack(i, i.getAmount() * multiplier), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public boolean tryRunOperations(IFluidHandler inventory) {
        if (this.operations != null) {
            for (FluidStack i : this.operations) {
                FluidStack drained = inventory.drain(i, IFluidHandler.FluidAction.SIMULATE);
                if (i.getAmount() <= drained.getAmount()) continue;
                return false;
            }
            for (FluidStack i : this.operations) {
                inventory.drain(new FluidStack(i, i.getAmount()), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return true;
    }

    public int getMaxRuns(IFluidHandler inventory) {
        int maxcount = 64;
        if (this.operations != null) {
            for (FluidStack i : this.operations) {
                int count = 0;
                for (int j = 0; j < inventory.getTanks(); ++j) {
                    FluidStack fs = inventory.getFluidInTank(j);
                    if (!i.equals((Object)fs)) continue;
                    count += fs.getAmount();
                }
                maxcount = Math.min(maxcount, count / i.getAmount());
            }
        }
        return maxcount;
    }
}

