/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.client.model.data.ModelData;

public record DynamicBlockModelReference(ResourceLocation name) implements Supplier<BakedModel>,
Function<ModelData, List<BakedQuad>>
{
    private static final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();
    public static final Function<ResourceLocation, DynamicBlockModelReference> cache;
    public static final Set<ResourceLocation> registeredModels;

    public static DynamicBlockModelReference getModelCached(ResourceLocation rl) {
        if (rl == null) {
            return null;
        }
        return cache.apply(rl);
    }

    public DynamicBlockModelReference register() {
        registeredModels.add(this.name);
        return this;
    }

    public static DynamicBlockModelReference getModelCached(String modid, String path) {
        return cache.apply(new ResourceLocation(modid, path));
    }

    @Override
    public BakedModel get() {
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110881_().getModel(this.name);
    }

    public List<BakedQuad> getAllQuads() {
        return this.apply(ModelData.EMPTY);
    }

    @Override
    public List<BakedQuad> apply(ModelData data) {
        return this.get().getQuads(null, null, RANDOM_SOURCE, data, null);
    }

    public static RandomSource getRandomSource() {
        return RANDOM_SOURCE;
    }

    static {
        RANDOM_SOURCE.m_188584_(42L);
        cache = Util.m_143827_(DynamicBlockModelReference::new);
        registeredModels = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

