/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ChangeDetectedItemHandler
extends ItemStackHandler {
    Runnable onchange;
    List<Runnable> slotOnChange;

    public ChangeDetectedItemHandler(int slots, Runnable onchange) {
        super(slots);
        this.onchange = onchange;
        this.slotOnChange = new ArrayList<Runnable>(this.getSlots());
    }

    public void addSlotListener(int slot, Runnable onchange) {
        while (this.slotOnChange.size() <= slot) {
            this.slotOnChange.add(null);
        }
        this.slotOnChange.set(slot, onchange);
    }

    public void addSlotListener(int minSlot, int maxSlot, Runnable onchange) {
        while (this.slotOnChange.size() < maxSlot) {
            this.slotOnChange.add(null);
        }
        for (int i = minSlot; i < maxSlot; ++i) {
            this.slotOnChange.set(i, onchange);
        }
    }

    protected void onContentsChanged(int slot) {
        this.onchange.run();
        if (this.slotOnChange.size() > slot && this.slotOnChange.get(slot) != null) {
            this.slotOnChange.get(slot).run();
        }
    }

    public void setStackInSlotNoChange(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
    }
}

