/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ChangeDetectedFluidHandler
implements IFluidHandler {
    Runnable onchange;
    IFluidHandler nested;

    public ChangeDetectedFluidHandler(IFluidHandler nested, Runnable onchange) {
        this.onchange = onchange;
        this.nested = nested;
    }

    public static <T extends BlockEntity> IFluidHandler fromBESetChanged(T blockEntity, IFluidHandler nested) {
        return new ChangeDetectedFluidHandler(nested, () -> blockEntity.m_6596_());
    }

    public int getTanks() {
        return this.nested.getTanks();
    }

    public FluidStack getFluidInTank(int t) {
        return this.nested.getFluidInTank(t);
    }

    public int getTankCapacity(int t) {
        return this.nested.getTankCapacity(t);
    }

    public boolean isFluidValid(int t, FluidStack stack) {
        return this.nested.isFluidValid(t, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = this.nested.fill(resource, action);
        if (filled != 0 && action.execute()) {
            this.onContentsChanged();
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = this.nested.drain(resource, action);
        if (!drained.isEmpty() && action.execute()) {
            this.onContentsChanged();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = this.nested.drain(maxDrain, action);
        if (!drained.isEmpty() && action.execute()) {
            this.onContentsChanged();
        }
        return drained;
    }

    protected void onContentsChanged() {
        this.onchange.run();
    }
}

