/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.util;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import com.mojang.datafixers.util.Pair;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityProcessor {
    Map<Capability<?>, CapabilityQuery<?>> capabilities = new IdentityHashMap();

    public <T> CapabilityProcessor addCapability(Capability<T> cap, CapabilityPosition pos, T obj) {
        this.capabilities.merge(cap, new SingleCapabilityQuery<T>(pos, obj), (a, b) -> a.append(b));
        return this;
    }

    public <T> CapabilityProcessor addCapability(Capability<T> cap, CapabilityFacing pos, T obj) {
        this.capabilities.merge(cap, new SingleCapabilityQuery<T>(pos.capPos(), obj), (a, b) -> a.append(b));
        return this;
    }

    public <T> CapabilityBuilder<T> addCapabilities(Capability<T> cap) {
        return new CapabilityBuilder<T>(this, cap);
    }

    public CapabilityBuilder<IItemHandler> itemHandler() {
        return this.addCapabilities(ForgeCapabilities.ITEM_HANDLER);
    }

    public CapabilityBuilder<IFluidHandler> fluidHandler() {
        return this.addCapabilities(ForgeCapabilities.FLUID_HANDLER);
    }

    public CapabilityBuilder<IEnergyStorage> energy() {
        return this.addCapabilities(ForgeCapabilities.ENERGY);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, CapabilityPosition pos, IMultiblockContext<?> ctx) {
        StoredCapability<?> storedCap;
        CapabilityQuery<?> qry = this.capabilities.get(cap);
        if (qry != null && (storedCap = qry.getCapabiltiy(pos)) != null) {
            return storedCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    private record SingleCapabilityQuery<T>(CapabilityPosition pos, StoredCapability<T> cap) implements CapabilityQuery<T>
    {
        public SingleCapabilityQuery(CapabilityPosition pos, T obj) {
            this(pos, new StoredCapability(obj));
        }

        @Override
        public StoredCapability<T> getCapabiltiy(CapabilityPosition pos) {
            if (this.pos.equals((Object)pos)) {
                return this.cap;
            }
            return null;
        }

        @Override
        public CapabilityQuery<T> append(CapabilityPosition pos, T capability) {
            MultipleCapabilityQuery<T> cap = new MultipleCapabilityQuery<T>();
            cap.cap.put(this.pos, this.cap);
            return cap.append(pos, capability);
        }

        @Override
        public Stream<Pair<CapabilityPosition, StoredCapability<T>>> getAll() {
            return Stream.of(Pair.of((Object)this.pos, this.cap));
        }

        @Override
        public CapabilityQuery<T> append(CapabilityQuery<T> other) {
            MultipleCapabilityQuery rs = new MultipleCapabilityQuery();
            this.getAll().forEach(t -> rs.cap.put((CapabilityPosition)t.getFirst(), (StoredCapability)t.getSecond()));
            other.getAll().forEach(t -> rs.cap.put((CapabilityPosition)t.getFirst(), (StoredCapability)t.getSecond()));
            return rs;
        }
    }

    public record CapabilityBuilder<T>(CapabilityProcessor proc, Capability<T> cap) {
        public CapabilityBuilder<T> addCapability(CapabilityPosition pos, T obj) {
            this.proc.addCapability(this.cap, pos, obj);
            return this;
        }

        public CapabilityBuilder<T> addCapability(CapabilityFacing pos, T obj) {
            this.proc.addCapability(this.cap, pos, obj);
            return this;
        }
    }

    private static interface CapabilityQuery<T> {
        public StoredCapability<T> getCapabiltiy(CapabilityPosition var1);

        public CapabilityQuery<T> append(CapabilityPosition var1, T var2);

        public CapabilityQuery<T> append(CapabilityQuery<T> var1);

        public Stream<Pair<CapabilityPosition, StoredCapability<T>>> getAll();
    }

    private static class MultipleCapabilityQuery<T>
    implements CapabilityQuery<T> {
        Map<CapabilityPosition, StoredCapability<T>> cap = new HashMap<CapabilityPosition, StoredCapability<T>>();

        private MultipleCapabilityQuery() {
        }

        @Override
        public StoredCapability<T> getCapabiltiy(CapabilityPosition pos) {
            return this.cap.get(pos);
        }

        @Override
        public CapabilityQuery<T> append(CapabilityPosition pos, T capability) {
            this.cap.put(pos, new StoredCapability(capability));
            return this;
        }

        @Override
        public Stream<Pair<CapabilityPosition, StoredCapability<T>>> getAll() {
            return this.cap.entrySet().stream().map(t -> Pair.of((Object)((CapabilityPosition)t.getKey()), (Object)((StoredCapability)t.getValue())));
        }

        @Override
        public CapabilityQuery<T> append(CapabilityQuery<T> other) {
            other.getAll().forEach(t -> this.cap.put((CapabilityPosition)t.getFirst(), (StoredCapability)t.getSecond()));
            return this;
        }
    }
}

