/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.steamturbine;

import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.ICommonMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import com.google.common.collect.ImmutableList;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.content.steamturbine.SteamTurbineLogic;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SteamTurbineState
implements IMultiblockState {
    public static final TagKey<Fluid> fluidTag = FluidTags.create((ResourceLocation)new ResourceLocation("forge", "steam"));
    public final RedstoneControl.RSState rsstate = RedstoneControl.RSState.enabledByDefault();
    public boolean active = false;
    public FluidTank tanks;
    BooleanSupplier isSoundPlaying;
    final StoredCapability<IFluidHandler> fluidCap;
    final StoredCapability<IEnergyStorage> energyView;
    ImmutableList<CapabilityReference<IEnergyStorage>> energyOutputs;
    float saturation;
    int energyBuffer;

    public SteamTurbineState(IInitialMultiblockContext<SteamTurbineState> capabilitySource) {
        this.tanks = new FluidTank(80 * (Integer)IIConfig.SERVER.steamTurbineInputMax.get(), fluidStack -> fluidStack.getFluid().m_205067_(fluidTag));
        this.isSoundPlaying = () -> false;
        this.energyView = new StoredCapability((Object)NullEnergyStorage.INSTANCE);
        this.saturation = 0.0f;
        this.energyBuffer = 0;
        ImmutableList.Builder outputs = ImmutableList.builder();
        outputs.add(SteamTurbineLogic.ENERGY_OUT1.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.ENERGY));
        outputs.add(SteamTurbineLogic.ENERGY_OUT2.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.ENERGY));
        this.energyOutputs = outputs.build();
        this.fluidCap = new StoredCapability((Object)ArrayFluidHandler.fillOnly((IFluidTank)this.tanks, (Runnable)capabilitySource.getMarkDirtyRunnable()));
    }

    public void writeSaveNBT(CompoundTag nbt) {
        this.tanks.writeToNBT(nbt);
        nbt.m_128379_("active", this.active);
        nbt.m_128350_("saturation", this.saturation);
        nbt.m_128405_("energyBuffer", this.energyBuffer);
    }

    public void readSaveNBT(CompoundTag nbt) {
        this.tanks.readFromNBT(nbt);
        this.active = nbt.m_128471_("active");
        this.saturation = nbt.m_128457_("saturation");
        this.energyBuffer = nbt.m_128451_("energyBuffer");
    }

    public void writeSyncNBT(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
    }

    public void readSyncNBT(CompoundTag nbt) {
        this.active = nbt.m_128471_("active");
    }
}

