/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.steamturbine;

import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.google.common.collect.ImmutableList;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.content.steamturbine.SteamTurbineState;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.LangUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.RegistryObject;

public class SteamTurbineLogic
implements IMultiblockLogic<SteamTurbineState>,
IServerTickableComponent<SteamTurbineState>,
IClientTickableComponent<SteamTurbineState> {
    static final CapabilityPosition FLUID_INPUT = new CapabilityPosition(2, 1, 0, RelativeBlockFace.FRONT);
    static final CapabilityFacing ENERGY_OUT1 = new CapabilityFacing(0, 1, 6, RelativeBlockFace.UP);
    static final CapabilityFacing ENERGY_OUT2 = new CapabilityFacing(2, 1, 6, RelativeBlockFace.UP);
    static final Function<BlockPos, List<AABB>> origfunc = posInMultiblock -> {
        if (posInMultiblock.m_123343_() == 0 && posInMultiblock.m_123341_() == 0) {
            return posInMultiblock.m_123342_() == 0 ? ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)new AABB(0.5, 0.5, 0.0, 0.0, 1.0, 1.0)) : ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
        }
        if (posInMultiblock.m_123343_() == 5 && posInMultiblock.m_123342_() == 1) {
            if (posInMultiblock.m_123341_() % 2 == 0) {
                return Utils.flipBoxes((boolean)false, (posInMultiblock.m_123341_() == 2 ? 1 : 0) != 0, (AABB[])new AABB[]{new AABB(1.0, 0.0, 0.0, 0.25, 0.5, 1.0)});
            }
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (posInMultiblock.m_123341_() % 2 == 0 && posInMultiblock.m_123343_() != 6) {
            if (posInMultiblock.m_123342_() == 0) {
                return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), (Object)Utils.flipBox((boolean)false, (posInMultiblock.m_123341_() == 2 ? 1 : 0) != 0, (AABB)new AABB(1.0, 0.5, 0.0, 0.25, 1.0, 1.0)));
            }
            if (posInMultiblock.m_123343_() == 0) {
                if (posInMultiblock.m_123342_() == 2) {
                    return ImmutableList.of((Object)new AABB(0.25, 0.0, 0.8, 0.75, 0.7, 1.0));
                }
                return ImmutableList.of((Object)new AABB(0.25, 0.25, 0.125, 0.75, 0.75, 1.0), (Object)new AABB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125));
            }
            if (posInMultiblock.m_123342_() == 1) {
                return Utils.flipBoxes((boolean)false, (posInMultiblock.m_123341_() == 2 ? 1 : 0) != 0, (AABB[])new AABB[]{new AABB(1.0, 0.0, 0.0, 0.25, 1.0, 1.0)});
            }
            return ImmutableList.of((Object)new AABB(0.25, 0.0, 1.0, 0.75, 0.7, 0.0));
        }
        if (posInMultiblock.m_123342_() == 2) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 1.0, 1.0, 0.5, 0.0));
        }
        if (posInMultiblock.equals((Object)new BlockPos(1, 0, 0))) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    };
    static final Function<BlockPos, VoxelShape> getterFunc = Util.m_143827_(origfunc.andThen(t -> t.stream().map(Shapes::m_83064_).reduce(Shapes.m_83040_(), Shapes::m_83110_)));

    public SteamTurbineState createInitialState(IInitialMultiblockContext<SteamTurbineState> capabilitySource) {
        return new SteamTurbineState(capabilitySource);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return getterFunc;
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<SteamTurbineState> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_INPUT.equalsOrNullFace(position)) {
            return ((SteamTurbineState)ctx.getState()).fluidCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ENERGY && (position.side() == RelativeBlockFace.UP || position.side() == null) && (ENERGY_OUT1.isCapabilityPosition(position) || ENERGY_OUT2.isCapabilityPosition(position))) {
            return ((SteamTurbineState)ctx.getState()).energyView.cast(ctx);
        }
        return super.getCapability(ctx, position, cap);
    }

    public void tickClient(IMultiblockContext<SteamTurbineState> context) {
        SteamTurbineState state = (SteamTurbineState)context.getState();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 3.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (RegistryObject)IESounds.dieselGenerator, (float)0.5f);
        }
    }

    public InteractionResult click(IMultiblockContext<SteamTurbineState> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (player.m_21120_(hand).m_150930_(IEItems.Tools.VOLTMETER.get())) {
            if (!player.m_9236_().f_46443_) {
                DecimalFormat num = new DecimalFormat("#0.0%");
                double saturationMin = (Double)IIConfig.SERVER.steamTurbineSaturationMin.get();
                player.m_213846_((Component)LangUtil.translate("message.immersiveindustry.steam_turbine.saturation", num.format(Mth.m_14008_((double)((double)((SteamTurbineState)ctx.getState()).saturation - saturationMin), (double)0.0, (double)((Double)IIConfig.SERVER.steamTurbineSaturationMax.get() - saturationMin)) + 1.0)));
            }
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        return super.click(ctx, posInMultiblock, player, hand, absoluteHit, isClient);
    }

    public void tickServer(IMultiblockContext<SteamTurbineState> context) {
        List presentOutputs;
        SteamTurbineState state = (SteamTurbineState)context.getState();
        boolean pactive = state.active;
        state.active = false;
        int minSteam = (Integer)IIConfig.SERVER.steamTurbineInputMin.get();
        if (state.rsstate.isEnabled(context) && state.tanks.getFluidAmount() >= minSteam && !(presentOutputs = state.energyOutputs.stream().map(CapabilityReference::getNullable).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            double saturationMin = (Double)IIConfig.SERVER.steamTurbineSaturationMin.get();
            int steamCost = Math.min(state.tanks.getFluidAmount(), (Integer)IIConfig.SERVER.steamTurbineInputMax.get());
            int out = (int)((double)steamCost * (Double)IIConfig.SERVER.steamTurbineGenerator.get() * (Mth.m_14008_((double)((double)state.saturation - saturationMin), (double)0.0, (double)((Double)IIConfig.SERVER.steamTurbineSaturationMax.get() - saturationMin)) + 1.0));
            if (state.energyBuffer < out) {
                state.saturation = (float)((double)state.saturation + (Double)IIConfig.SERVER.steamTurbineSaturationRate.get() * (double)steamCost);
                state.active = true;
                state.tanks.drain(steamCost, IFluidHandler.FluidAction.EXECUTE);
                state.energyBuffer += out;
                context.markMasterDirty();
            }
            if (state.energyBuffer > 0) {
                int preOut = state.energyBuffer;
                state.energyBuffer = EnergyHelper.distributeFlux(presentOutputs, (int)state.energyBuffer, (boolean)false);
                if (state.energyBuffer != preOut) {
                    context.markMasterDirty();
                }
            }
        }
        if (state.saturation != 0.0f) {
            state.saturation = (float)((double)state.saturation - (double)state.saturation * (Double)IIConfig.SERVER.steamTurbineUnsaturationRate.get());
            state.saturation = Math.max(0.0f, state.saturation);
            context.markMasterDirty();
        }
        if (pactive != state.active) {
            context.markDirtyAndSync();
        }
    }
}

