/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.ICommonMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnLogic;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnProcess;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import com.teammoeg.immersiveindustry.util.CapabilityProcessor;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.RangedCheckedInputWrapper;
import com.teammoeg.immersiveindustry.util.RangedOutputWrapper;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class RotaryKilnState
implements IMultiblockState {
    boolean active;
    public ChangeDetectedItemHandler inventory;
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(16000);
    public FluidTank tankout = new FluidTank(32000);
    public RotaryKilnProcess[] processes = new RotaryKilnProcess[2];
    public int angle;
    BooleanSupplier isSoundPlaying = () -> false;
    CapabilityProcessor capabilities = new CapabilityProcessor();
    CapabilityReference<IItemHandler> outInvCap;
    CapabilityReference<IFluidHandler> outFluidCap;
    public final RedstoneControl.RSState state = RedstoneControl.RSState.enabledByDefault();

    public RotaryKilnState(IInitialMultiblockContext<RotaryKilnState> capabilitySource) {
        this.inventory = new ChangeDetectedItemHandler(5, capabilitySource.getMarkDirtyRunnable());
        this.capabilities.itemHandler().addCapability(RotaryKilnLogic.itemin, (IItemHandler)new RangedCheckedInputWrapper((IItemHandlerModifiable)this.inventory, 0, 1, (s, r) -> RotaryKilnRecipe.isValidRecipeInput((Level)capabilitySource.levelSupplier().get(), r))).addCapability(RotaryKilnLogic.itemout, (IItemHandler)new RangedOutputWrapper((IItemHandlerModifiable)this.inventory, 3, 5));
        this.capabilities.fluidHandler().addCapability(RotaryKilnLogic.fluidout, (IFluidHandler)ArrayFluidHandler.drainOnly((IFluidTank)this.tankout, (Runnable)capabilitySource.getMarkDirtyRunnable()));
        this.capabilities.energy().addCapability(RotaryKilnLogic.powerin, (IEnergyStorage)new WrappingEnergyStorage((IEnergyStorage)this.energyStorage, true, false, capabilitySource.getMarkDirtyRunnable()));
        this.outInvCap = RotaryKilnLogic.itemout.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.ITEM_HANDLER);
        this.outFluidCap = RotaryKilnLogic.fluidout.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.FLUID_HANDLER);
    }

    public void writeSaveNBT(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
        nbt.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.serializeNBT());
        nbt.m_128365_("fluid", (Tag)this.tankout.writeToNBT(new CompoundTag()));
        if (this.processes[0] != null) {
            nbt.m_128365_("process0", (Tag)this.processes[0].save());
        }
        if (this.processes[1] != null) {
            nbt.m_128365_("process1", (Tag)this.processes[1].save());
        }
    }

    public void readSaveNBT(CompoundTag nbt) {
        CompoundTag tag;
        this.active = nbt.m_128471_("active");
        this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        this.energyStorage.deserializeNBT(nbt.m_128423_("energy"));
        this.tankout.readFromNBT(nbt.m_128469_("fluid"));
        if (nbt.m_128441_("process0")) {
            tag = nbt.m_128469_("process0");
            if (this.processes[0] == null) {
                this.processes[0] = new RotaryKilnProcess(tag);
            } else {
                this.processes[0].load(tag);
            }
        } else {
            this.processes[0] = null;
        }
        if (nbt.m_128441_("process1")) {
            tag = nbt.m_128469_("process1");
            if (this.processes[1] == null) {
                this.processes[1] = new RotaryKilnProcess(tag);
            } else {
                this.processes[1].load(tag);
            }
        } else {
            this.processes[1] = null;
        }
    }

    public void writeSyncNBT(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
    }

    public void readSyncNBT(CompoundTag nbt) {
        this.active = nbt.m_128471_("active");
    }
}

