/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class RotaryKilnRecipeSerializer
extends IERecipeSerializer<RotaryKilnRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IIContent.IIMultiblocks.ROTARY_KILN.blockItem().get());
    }

    @Nullable
    public RotaryKilnRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        return new RotaryKilnRecipe(recipeId, buffer.m_130267_(), IngredientWithSize.read((FriendlyByteBuf)buffer), FluidStack.readFromPacket((FriendlyByteBuf)buffer), buffer.m_130242_(), buffer.m_130242_(), buffer.readBoolean() ? StackWithChance.read((FriendlyByteBuf)buffer) : null);
    }

    public void toNetwork(FriendlyByteBuf buffer, RotaryKilnRecipe recipe) {
        buffer.m_130055_(recipe.output);
        recipe.input.write(buffer);
        recipe.output_fluid.writeToPacket(buffer);
        buffer.m_130130_(recipe.time);
        buffer.m_130130_(recipe.tickEnergy);
        if (recipe.secoutput == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            recipe.secoutput.write(buffer);
        }
    }

    public RotaryKilnRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        ItemStack output = ItemStack.f_41583_;
        if (json.has("result")) {
            output = (ItemStack)RotaryKilnRecipeSerializer.readOutput((JsonElement)json.get("result")).get();
        }
        IngredientWithSize input = IngredientWithSize.deserialize((JsonElement)json.get("input"));
        FluidStack result_fluid = FluidStack.EMPTY;
        if (json.has("result_fluid")) {
            result_fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)json.get("result_fluid").getAsJsonObject());
        }
        int time = 200;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = 32;
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        StackWithChance byout = null;
        if (json.has("byproduct")) {
            byout = RotaryKilnRecipeSerializer.readConditionalStackWithChance((JsonElement)json.get("byproduct"), (ICondition.IContext)context);
        }
        return new RotaryKilnRecipe(recipeId, output, input, result_fluid, time, tickEnergy, byout);
    }
}

