/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class RotaryKilnProcess {
    int process;
    int processMax;
    int powerUsage;
    ResourceLocation recipeId;
    RotaryKilnRecipe recipeCache;

    public RotaryKilnProcess(RotaryKilnRecipe recipe) {
        this.process = 0;
        this.setRecipe(recipe);
    }

    public RotaryKilnProcess(CompoundTag tag) {
        this.load(tag);
    }

    public RotaryKilnRecipe getRecipe(Level level) {
        if (this.recipeCache == null) {
            RotaryKilnRecipe rcp = (RotaryKilnRecipe)RotaryKilnRecipe.recipeList.getById(level, this.recipeId);
            this.setRecipe(rcp);
        }
        return this.recipeCache;
    }

    public void setRecipe(RotaryKilnRecipe recipe) {
        this.recipeId = recipe.m_6423_();
        this.recipeCache = recipe;
        this.processMax = recipe.time;
        this.powerUsage = recipe.tickEnergy;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("process", this.process);
        tag.m_128405_("processMax", this.processMax);
        tag.m_128405_("power", this.powerUsage);
        tag.m_128359_("recipe", this.recipeId.toString());
        return tag;
    }

    public void load(CompoundTag tag) {
        this.process = tag.m_128451_("process");
        this.processMax = tag.m_128451_("processMax");
        this.powerUsage = tag.m_128451_("power");
        ResourceLocation newId = new ResourceLocation(tag.m_128461_("recipe"));
        if (!newId.equals((Object)this.recipeId)) {
            this.recipeCache = null;
        }
        this.recipeId = newId;
    }
}

