/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnProcess;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnState;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.IIUtil;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class RotaryKilnLogic
implements IMultiblockLogic<RotaryKilnState>,
IClientTickableComponent<RotaryKilnState>,
IServerTickableComponent<RotaryKilnState> {
    static final CapabilityFacing itemout = new CapabilityFacing(1, 0, 6, RelativeBlockFace.BACK);
    static final CapabilityFacing powerin = new CapabilityFacing(1, 0, 0, RelativeBlockFace.FRONT);
    static final CapabilityFacing itemin = new CapabilityFacing(1, 2, 0, RelativeBlockFace.UP);
    static final CapabilityFacing fluidout = new CapabilityFacing(1, 2, 4, RelativeBlockFace.UP);
    static final Function<BlockPos, VoxelShape> shapeCache = Util.m_143827_(RotaryKilnLogic::getShape);

    public void tickServer(IMultiblockContext<RotaryKilnState> context) {
        RotaryKilnState state = (RotaryKilnState)context.getState();
        boolean update = false;
        boolean lastActive = state.active;
        state.active = false;
        boolean needRun = false;
        int energycost = 0;
        if (state.state.isEnabled(context)) {
            int extracted;
            if (state.processes[1] != null && state.processes[1].process >= state.processes[1].processMax) {
                RotaryKilnRecipe rcp = state.processes[1].getRecipe(context.getLevel().getRawLevel());
                ItemStack process1Slot = state.inventory.getStackInSlot(2);
                ItemStack outSlot = state.inventory.getStackInSlot(3);
                ItemStack secoutSlot = state.inventory.getStackInSlot(4);
                if ((outSlot.m_41619_() || rcp.output.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)outSlot, (ItemStack)rcp.output)) && (secoutSlot.m_41619_() || rcp.secoutput == null || ItemHandlerHelper.canItemStacksStack((ItemStack)secoutSlot, (ItemStack)((ItemStack)rcp.secoutput.stack().get()))) && (state.tankout.isEmpty() || rcp.output_fluid.isEmpty() || state.tankout.fill(rcp.output_fluid, IFluidHandler.FluidAction.SIMULATE) == rcp.output_fluid.getAmount())) {
                    int maxoutcount = outSlot.m_41741_() - outSlot.m_41613_();
                    int maxsecoutcount = secoutSlot.m_41741_() - secoutSlot.m_41613_();
                    int maxouttimes = 64;
                    if (!rcp.output.m_41619_()) {
                        maxouttimes = Math.min(maxoutcount / rcp.output.m_41613_(), maxouttimes);
                    }
                    if (rcp.secoutput != null) {
                        maxouttimes = (int)Math.min((float)maxsecoutcount / ((float)((ItemStack)rcp.secoutput.stack().get()).m_41613_() * rcp.secoutput.chance()), (float)maxouttimes);
                    }
                    if (!rcp.output_fluid.isEmpty()) {
                        maxouttimes = Math.min(state.tankout.getSpace() / rcp.output_fluid.getAmount(), maxouttimes);
                    }
                    if ((maxouttimes = Math.min(process1Slot.m_41613_() / rcp.input.getCount(), maxouttimes)) > 0) {
                        int inputNum = maxouttimes * rcp.input.getCount();
                        process1Slot.m_41774_(inputNum);
                        state.inventory.setStackInSlotNoChange(2, process1Slot);
                        if (!rcp.output.m_41619_()) {
                            IIUtil.insertToOutput((IItemHandlerModifiable)state.inventory, 3, rcp.output.m_255036_(maxouttimes * rcp.output.m_41613_()));
                        }
                        if (!rcp.output_fluid.isEmpty()) {
                            state.tankout.fill(new FluidStack(rcp.output_fluid, rcp.output_fluid.getAmount() * maxouttimes), IFluidHandler.FluidAction.EXECUTE);
                        }
                        if (rcp.secoutput != null) {
                            RandomSource rnd = context.getLevel().getRawLevel().f_46441_;
                            int tcount = 0;
                            for (int i = 0; i < maxouttimes; ++i) {
                                if (!(rcp.secoutput.chance() >= rnd.m_188501_())) continue;
                                ++tcount;
                            }
                            IIUtil.insertToOutput((IItemHandlerModifiable)state.inventory, 4, ((ItemStack)rcp.secoutput.stack().get()).m_255036_(tcount * ((ItemStack)rcp.secoutput.stack().get()).m_41613_()));
                        }
                        update = true;
                    }
                    if (process1Slot.m_41619_()) {
                        state.processes[1] = null;
                        update = true;
                    }
                }
            }
            if (state.processes[0] != null && state.processes[0].process >= state.processes[0].processMax / 2 && state.processes[1] == null) {
                state.processes[1] = state.processes[0];
                state.processes[0] = null;
                ItemStack process0Slot = state.inventory.getStackInSlot(1);
                state.inventory.setStackInSlot(1, ItemStack.f_41583_);
                state.inventory.setStackInSlot(2, process0Slot);
                update = true;
            }
            if (state.processes[0] == null && !state.inventory.getStackInSlot(0).m_41619_()) {
                ItemStack inputSlot = state.inventory.getStackInSlot(0);
                RotaryKilnRecipe rcp = RotaryKilnRecipe.findRecipe(context);
                if (rcp != null) {
                    state.processes[0] = new RotaryKilnProcess(rcp);
                    int inCount = inputSlot.m_41613_() / rcp.input.getCount();
                    ItemStack process0Slot = inputSlot.m_255036_(inCount * rcp.input.getCount());
                    state.inventory.setStackInSlot(1, process0Slot);
                    inputSlot.m_41774_(inCount);
                    state.inventory.setStackInSlot(0, inputSlot);
                    update = true;
                }
            }
            if (state.processes[0] != null) {
                energycost = Math.max(state.processes[0].powerUsage, energycost);
                needRun = true;
            }
            if (state.processes[1] != null) {
                energycost = Math.max(state.processes[1].powerUsage, energycost);
                needRun = true;
            }
            if (needRun && (extracted = state.energyStorage.extractEnergy(energycost = (int)((double)energycost * (Double)IIConfig.SERVER.rotaryKilnBaseRate.get()), true)) >= energycost) {
                state.energyStorage.extractEnergy(energycost, false);
                state.active = true;
                if (state.processes[0] != null && state.processes[0].process < state.processes[0].processMax) {
                    ++state.processes[0].process;
                }
                if (state.processes[1] != null && state.processes[1].process < state.processes[1].processMax) {
                    ++state.processes[1].process;
                }
                update = true;
            }
        }
        if (update |= this.tryOutput(context)) {
            context.markMasterDirty();
        }
        if (lastActive != state.active) {
            context.requestMasterBESync();
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<RotaryKilnState> ctx, CapabilityPosition position, Capability<T> cap) {
        return ((RotaryKilnState)ctx.getState()).capabilities.getCapability(cap, position, ctx);
    }

    public void tickClient(IMultiblockContext<RotaryKilnState> context) {
        RotaryKilnState state = (RotaryKilnState)context.getState();
        if (state.active) {
            state.angle += 10;
            if (state.angle >= 360) {
                state.angle = 0;
            }
        }
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (RegistryObject)IESounds.arcFurnace, (float)0.075f);
        }
    }

    public RotaryKilnState createInitialState(IInitialMultiblockContext<RotaryKilnState> capabilitySource) {
        return new RotaryKilnState(capabilitySource);
    }

    static VoxelShape getShape(BlockPos pos) {
        if (pos.m_123341_() == 1 && pos.m_123342_() == 0) {
            return Shapes.m_83144_();
        }
        if (pos.m_123341_() == 1 && pos.m_123342_() == 1 && pos.m_123343_() != 0 && pos.m_123343_() != 6) {
            return Shapes.m_83144_();
        }
        if (pos.m_123341_() == 0 & pos.m_123342_() <= 1 && pos.m_123343_() == 5) {
            return Shapes.m_83144_();
        }
        VoxelShape res = Shapes.m_83040_();
        if (pos.m_123342_() == 0) {
            res = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (pos.m_123343_() == 0) {
            if (pos.m_123341_() == 0) {
                res = Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.5625, (double)1.0, (double)1.0, (double)1.0));
            }
            if (pos.m_123341_() == 2) {
                res = Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5625, (double)0.5625, (double)1.0, (double)1.0));
            }
            if (pos.m_123341_() == 1) {
                if (pos.m_123342_() == 2) {
                    return Shapes.m_83110_((VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75)), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)0.5, (double)1.0));
                }
                return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.5625, (double)0.25, (double)0.75, (double)1.0, (double)0.75));
            }
        } else if (pos.m_123343_() == 6) {
            if (pos.m_123341_() == 0) {
                res = Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.84375, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.8125));
            }
            if (pos.m_123341_() == 2) {
                res = Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.15625, (double)1.0, (double)0.8125));
            }
            if (pos.m_123341_() == 1) {
                res = pos.m_123342_() == 2 ? Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)0.8125) : Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.8125);
            }
        } else {
            if (pos.m_123341_() == 0) {
                res = pos.m_123343_() == 5 || pos.m_123343_() == 1 ? Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0)) : Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0));
            }
            if (pos.m_123341_() == 2) {
                res = pos.m_123343_() == 5 || pos.m_123343_() == 1 ? Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.5625, (double)0.875, (double)1.0)) : Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.5625, (double)0.75, (double)1.0));
            }
            if (pos.m_123341_() == 1) {
                if (pos.m_123342_() == 2) {
                    if (pos.m_123343_() == 5 || pos.m_123343_() == 1) {
                        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0);
                    }
                    res = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
                    if (pos.m_123343_() == 4) {
                        res = Shapes.m_83110_((VoxelShape)res, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875));
                    }
                } else {
                    res = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
                }
            }
        }
        return res;
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return shapeCache;
    }

    public boolean tryOutput(IMultiblockContext<RotaryKilnState> context) {
        RotaryKilnState state = (RotaryKilnState)context.getState();
        boolean update = FluidUtils.multiblockFluidOutput(state.outFluidCap, (FluidTank)state.tankout, (int)0, (int)0, null);
        if (context.getLevel().shouldTickModulo(8)) {
            ChangeDetectedItemHandler inventory = state.inventory;
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outInvCap, 3);
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outInvCap, 4);
        }
        return update;
    }

    public void dropExtraItems(RotaryKilnState state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }
}

