/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.rotarykiln;

import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.rotarykiln.RotaryKilnRecipe;
import com.teammoeg.immersiveindustry.util.LangUtil;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RotaryKilnCategory
implements IRecipeCategory<RotaryKilnRecipe> {
    public static RecipeType<RotaryKilnRecipe> UID = new RecipeType(new ResourceLocation("immersiveindustry", "rotary_kiln"), RotaryKilnRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;
    private IDrawable TANK;
    private IDrawableAnimated ARROW;

    public RotaryKilnCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)IIContent.IIMultiblocks.ROTARY_KILN.blockItem().get()));
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/rotary_kiln.png"), 9, 22, 143, 59);
        this.TANK = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/rotary_kiln.png"), 197, 1, 18, 48);
        IDrawableStatic arrow = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/rotary_kiln.png"), 178, 59, 38, 16);
        this.ARROW = guiHelper.createAnimatedDrawable(arrow, 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<RotaryKilnRecipe> getRecipeType() {
        return UID;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RotaryKilnRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 18).addItemStacks(recipe.input.getMatchingStackList());
        IRecipeSlotBuilder itemOut = builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 41);
        if (!recipe.output.m_41619_()) {
            itemOut.addItemStack(recipe.output);
        }
        IRecipeSlotBuilder itemSecOut = builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 41);
        if (recipe.secoutput != null) {
            ((IRecipeSlotBuilder)itemSecOut.addItemStack((ItemStack)recipe.secoutput.stack().get())).addTooltipCallback((l, t) -> t.add(LangUtil.translate("gui.jei.category.immersiveindustry.rotary_kiln.chance", (int)(recipe.secoutput.chance() * 10000.0f) / 100).m_130940_(ChatFormatting.BLUE)));
        }
        IRecipeSlotBuilder fluidOut = builder.addSlot(RecipeIngredientRole.OUTPUT, 124, 4).setFluidRenderer(3200L, false, 16, 47).setOverlay(this.TANK, 0, 0);
        if (!recipe.output_fluid.isEmpty()) {
            fluidOut.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.output_fluid);
        }
    }

    public void draw(RotaryKilnRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.ARROW.draw(guiGraphics, 79, 22);
    }

    public Component getTitle() {
        return LangUtil.translate("gui.jei.category.immersiveindustry.rotary_kiln", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }
}

