/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.WrappingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.ICommonMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerLogic;
import com.teammoeg.immersiveindustry.util.CapabilityProcessor;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.RangedCheckedInputWrapper;
import com.teammoeg.immersiveindustry.util.RangedOutputWrapper;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class IndustrialElectrolyzerState
implements IMultiblockState {
    public RecipeHandler<ElectrolyzerRecipe> recipe;
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000);
    public FluidTank[] tank = new FluidTank[]{null, new FluidTank(16000)};
    public ChangeDetectedItemHandler inventory;
    boolean hasElectrode1 = false;
    boolean hasElectrode2 = false;
    boolean active;
    BooleanSupplier isSoundPlaying = () -> false;
    CapabilityReference<IItemHandler> outInvCap1;
    CapabilityReference<IFluidHandler> outFluidCap1;
    CapabilityReference<IItemHandler> outInvCap2;
    CapabilityReference<IFluidHandler> outFluidCap2;
    CapabilityProcessor capabilities = new CapabilityProcessor();
    public final RedstoneControl.RSState state = RedstoneControl.RSState.enabledByDefault();

    public IndustrialElectrolyzerState(IInitialMultiblockContext<IndustrialElectrolyzerState> capabilitySource) {
        Supplier l = capabilitySource.levelSupplier();
        this.inventory = new ChangeDetectedItemHandler(5, capabilitySource.getMarkDirtyRunnable());
        this.recipe = new RecipeHandler<ElectrolyzerRecipe>((t, r) -> r.time);
        this.inventory.addSlotListener(0, 2, this.recipe::onContainerChanged);
        this.tank[0] = new FluidTank(16000, arg_0 -> IndustrialElectrolyzerState.lambda$new$2((Supplier)l, arg_0));
        ArrayFluidHandler inFluidHandler1 = ArrayFluidHandler.fillOnly((IFluidTank)this.tank[0], () -> {
            capabilitySource.getMarkDirtyRunnable().run();
            this.recipe.onContainerChanged();
        });
        ArrayFluidHandler inFluidHandler2 = ArrayFluidHandler.fillOnly((IFluidTank)this.tank[0], () -> {
            capabilitySource.getMarkDirtyRunnable().run();
            this.recipe.onContainerChanged();
        });
        this.outFluidCap1 = IndustrialElectrolyzerLogic.out1.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.FLUID_HANDLER);
        this.outFluidCap2 = IndustrialElectrolyzerLogic.out2.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.FLUID_HANDLER);
        this.outInvCap1 = IndustrialElectrolyzerLogic.out1.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.ITEM_HANDLER);
        this.outInvCap2 = IndustrialElectrolyzerLogic.out2.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.ITEM_HANDLER);
        this.capabilities.fluidHandler().addCapability(IndustrialElectrolyzerLogic.in1, (IFluidHandler)inFluidHandler1).addCapability(IndustrialElectrolyzerLogic.in2, (IFluidHandler)inFluidHandler2).addCapability(IndustrialElectrolyzerLogic.out1, (IFluidHandler)ArrayFluidHandler.drainOnly((IFluidTank)this.tank[1], (Runnable)capabilitySource.getMarkDirtyRunnable())).addCapability(IndustrialElectrolyzerLogic.out2, (IFluidHandler)ArrayFluidHandler.drainOnly((IFluidTank)this.tank[1], (Runnable)capabilitySource.getMarkDirtyRunnable()));
        this.capabilities.itemHandler().addCapability(IndustrialElectrolyzerLogic.in1, (IItemHandler)new RangedCheckedInputWrapper((IItemHandlerModifiable)this.inventory, 0, 2, (arg_0, arg_1) -> IndustrialElectrolyzerState.lambda$new$5((Supplier)l, arg_0, arg_1))).addCapability(IndustrialElectrolyzerLogic.in2, (IItemHandler)new RangedCheckedInputWrapper((IItemHandlerModifiable)this.inventory, 0, 2, (arg_0, arg_1) -> IndustrialElectrolyzerState.lambda$new$6((Supplier)l, arg_0, arg_1))).addCapability(IndustrialElectrolyzerLogic.out1, (IItemHandler)new RangedOutputWrapper((IItemHandlerModifiable)this.inventory, 4, 5)).addCapability(IndustrialElectrolyzerLogic.out2, (IItemHandler)new RangedOutputWrapper((IItemHandlerModifiable)this.inventory, 4, 5));
        this.capabilities.energy().addCapability(IndustrialElectrolyzerLogic.energy, (IEnergyStorage)new WrappingEnergyStorage((IEnergyStorage)this.energyStorage, true, false, capabilitySource.getMarkDirtyRunnable()));
    }

    public void writeSaveNBT(CompoundTag nbt) {
        this.recipe.writeCustomNBT(nbt, false);
        nbt.m_128365_("energy", this.energyStorage.serializeNBT());
        nbt.m_128365_("tank0", (Tag)this.tank[0].writeToNBT(new CompoundTag()));
        nbt.m_128365_("tank1", (Tag)this.tank[1].writeToNBT(new CompoundTag()));
        nbt.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        nbt.m_128379_("elec1", this.hasElectrode1);
        nbt.m_128379_("elec2", this.hasElectrode2);
    }

    public void readSaveNBT(CompoundTag nbt) {
        this.recipe.readCustomNBT(nbt, false);
        this.energyStorage.deserializeNBT(nbt.m_128423_("energy"));
        this.tank[0].readFromNBT(nbt.m_128469_("tank0"));
        this.tank[1].readFromNBT(nbt.m_128469_("tank1"));
        this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        this.hasElectrode1 = nbt.m_128471_("elec1");
        this.hasElectrode2 = nbt.m_128471_("elec2");
    }

    public void writeSyncNBT(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
        nbt.m_128379_("elec1", this.hasElectrode1);
        nbt.m_128379_("elec2", this.hasElectrode2);
    }

    public void readSyncNBT(CompoundTag nbt) {
        this.active = nbt.m_128471_("active");
        this.hasElectrode1 = nbt.m_128471_("elec1");
        this.hasElectrode2 = nbt.m_128471_("elec2");
    }

    private static /* synthetic */ boolean lambda$new$6(Supplier l, Integer i, ItemStack r) {
        return ElectrolyzerRecipe.isValidRecipeInput((Level)l.get(), r);
    }

    private static /* synthetic */ boolean lambda$new$5(Supplier l, Integer i, ItemStack r) {
        return ElectrolyzerRecipe.isValidRecipeInput((Level)l.get(), r);
    }

    private static /* synthetic */ boolean lambda$new$2(Supplier l, FluidStack f) {
        return ElectrolyzerRecipe.isValidRecipeFluid((Level)l.get(), f);
    }
}

