/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerContainer;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerState;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.IIUtil;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class IndustrialElectrolyzerLogic
implements IMultiblockLogic<IndustrialElectrolyzerState>,
IClientTickableComponent<IndustrialElectrolyzerState>,
IServerTickableComponent<IndustrialElectrolyzerState> {
    static final CapabilityFacing out1 = new CapabilityFacing(2, 0, 3, RelativeBlockFace.LEFT);
    static final CapabilityFacing out2 = new CapabilityFacing(0, 0, 3, RelativeBlockFace.RIGHT);
    static final CapabilityFacing in1 = new CapabilityFacing(2, 0, 1, RelativeBlockFace.LEFT);
    static final CapabilityFacing in2 = new CapabilityFacing(0, 0, 1, RelativeBlockFace.RIGHT);
    static final CapabilityFacing energy = new CapabilityFacing(1, 1, 0, RelativeBlockFace.FRONT);

    public void tickServer(IMultiblockContext<IndustrialElectrolyzerState> context) {
        IndustrialElectrolyzerState state = (IndustrialElectrolyzerState)context.getState();
        if (this.tryOutput(context)) {
            context.markMasterDirty();
        }
        boolean hasElectrode1 = state.inventory.getStackInSlot(2).m_204117_(IndustrialElectrolyzerContainer.Electrode_Tag);
        boolean hasElectrode2 = state.inventory.getStackInSlot(3).m_204117_(IndustrialElectrolyzerContainer.Electrode_Tag);
        if (state.hasElectrode1 != hasElectrode1 || state.hasElectrode2 != hasElectrode2) {
            state.hasElectrode1 = hasElectrode1;
            state.hasElectrode2 = hasElectrode2;
            context.markDirtyAndSync();
        }
        if (state.state.isEnabled(context) && hasElectrode1 && hasElectrode2) {
            RecipeHandler<ElectrolyzerRecipe> handler = state.recipe;
            ChangeDetectedItemHandler inventory = state.inventory;
            if (handler.shouldTestRecipe()) {
                RecipeProcessResult<ElectrolyzerRecipe> recipeResult = ElectrolyzerRecipe.findRecipe(context);
                handler.setRecipe(recipeResult);
                context.markMasterDirty();
            }
            RandomSource rs = context.getLevel().getRawLevel().f_46441_;
            boolean lastActive = state.active;
            state.active = false;
            if (handler.shouldTickProcess()) {
                ElectrolyzerRecipe rcp = (ElectrolyzerRecipe)ElectrolyzerRecipe.recipeList.getById(context.getLevel().getRawLevel(), handler.getLastRecipe());
                int energyConsume = (int)((double)(rcp.tickEnergy * 6) * (Double)IIConfig.SERVER.electrolyzerBaseRate.get());
                if (state.energyStorage.extractEnergy(energyConsume, true) >= energyConsume && handler.tickProcess(8)) {
                    int duracost = IIUtil.randomValue(rs, (Double)IIConfig.SERVER.electrodeCost.get());
                    if (duracost > 0) {
                        for (int ele = 2; ele < 4; ++ele) {
                            if (!inventory.getStackInSlot(ele).m_220157_(1, rs, null)) continue;
                            inventory.setStackInSlotNoChange(ele, ItemStack.f_41583_);
                        }
                    }
                    state.energyStorage.extractEnergy(energyConsume, false);
                    state.active = true;
                }
                if (handler.isRecipeFinished()) {
                    RecipeProcessResult<ElectrolyzerRecipe> recipeResult = handler.getRecipeResultCache();
                    if (recipeResult != null) {
                        ElectrolyzerRecipe recipe = recipeResult.recipe();
                        if (inventory.insertItem(4, recipe.output, true).m_41619_() && state.tank[1].fill(recipe.output_fluid, IFluidHandler.FluidAction.SIMULATE) >= recipe.output_fluid.getAmount()) {
                            recipeResult.runOperations((IItemHandlerModifiable)inventory, (IFluidHandler)state.tank[0]);
                            inventory.insertItem(4, recipe.output.m_41777_(), false);
                            state.tank[1].fill(recipe.output_fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                            handler.endProcess();
                        }
                    } else {
                        handler.endProcess();
                    }
                }
                context.markMasterDirty();
            }
            if (state.active != lastActive) {
                context.requestMasterBESync();
            }
        }
    }

    public boolean tryOutput(IMultiblockContext<IndustrialElectrolyzerState> context) {
        IndustrialElectrolyzerState state = (IndustrialElectrolyzerState)context.getState();
        boolean update = FluidUtils.multiblockFluidOutput(state.outFluidCap1, (FluidTank)state.tank[1], (int)0, (int)0, null);
        update |= FluidUtils.multiblockFluidOutput(state.outFluidCap2, (FluidTank)state.tank[1], (int)0, (int)0, null);
        if (context.getLevel().shouldTickModulo(8)) {
            ChangeDetectedItemHandler inventory = state.inventory;
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outInvCap1, 4);
            update |= IIUtil.outputItem((IItemHandlerModifiable)inventory, state.outInvCap2, 4);
        }
        return update;
    }

    public void tickClient(IMultiblockContext<IndustrialElectrolyzerState> context) {
        IndustrialElectrolyzerState state = (IndustrialElectrolyzerState)context.getState();
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (RegistryObject)IESounds.tesla, (float)0.075f);
        }
    }

    public IndustrialElectrolyzerState createInitialState(IInitialMultiblockContext<IndustrialElectrolyzerState> capabilitySource) {
        return new IndustrialElectrolyzerState(capabilitySource);
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return t -> Shapes.m_83144_();
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<IndustrialElectrolyzerState> ctx, CapabilityPosition position, Capability<T> cap) {
        return ((IndustrialElectrolyzerState)ctx.getState()).capabilities.getCapability(cap, position, ctx);
    }

    public InteractionResult click(IMultiblockContext<IndustrialElectrolyzerState> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (posInMultiblock.m_123342_() == 2 && player.m_21120_(hand).m_204117_(IndustrialElectrolyzerContainer.Electrode_Tag)) {
            ChangeDetectedItemHandler handler = ((IndustrialElectrolyzerState)ctx.getState()).inventory;
            for (int i = 2; i <= 3; ++i) {
                if (!handler.getStackInSlot(i).m_41619_()) continue;
                handler.setStackInSlot(i, ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(hand), (int)1));
                player.m_21120_(hand).m_41774_(1);
                return InteractionResult.m_19078_((boolean)ctx.getLevel().getRawLevel().f_46443_);
            }
        }
        return super.click(ctx, posInMultiblock, player, hand, absoluteHit, isClient);
    }

    public void dropExtraItems(IndustrialElectrolyzerState state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }
}

