/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.util.JEISlotBuilder;
import com.teammoeg.immersiveindustry.util.LangUtil;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class IndustrialElectrolyzerCategory
implements IRecipeCategory<ElectrolyzerRecipe> {
    public static RecipeType<ElectrolyzerRecipe> UID = new RecipeType(new ResourceLocation("immersiveindustry", "industrial_electrolyzer"), ElectrolyzerRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;
    private IDrawable TANK;
    private IDrawableAnimated ARROW;
    public static final TagKey<Item> Electrode_Tag = ItemTags.create((ResourceLocation)new ResourceLocation("immersiveindustry", "electrodes"));

    public IndustrialElectrolyzerCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)IIContent.IIMultiblocks.INDUSTRIAL_ELECTROLYZER.blockItem().get()));
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/industrial_electrolyzer.png"), 6, 6, 145, 68);
        this.TANK = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/industrial_electrolyzer.png"), 197, 1, 18, 48);
        IDrawableStatic arrow = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/industrial_electrolyzer.png"), 178, 57, 21, 15);
        this.ARROW = guiHelper.createAnimatedDrawable(arrow, 20, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<ElectrolyzerRecipe> getRecipeType() {
        return UID;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ElectrolyzerRecipe recipe, IFocusGroup focuses) {
        JEISlotBuilder<ItemStack> itemInput = JEISlotBuilder.itemStack(builder, JEIIngredientStackListBuilder.make((IngredientWithSize[])recipe.inputs).build()).asInput();
        itemInput.addSlot(28, 33);
        itemInput.addSlot(46, 33);
        List electrode = ForgeRegistries.ITEMS.tags().getTag(Electrode_Tag).stream().map(ItemStack::new).collect(Collectors.toList());
        builder.addSlot(RecipeIngredientRole.CATALYST, 28, 4).addItemStacks(electrode);
        builder.addSlot(RecipeIngredientRole.CATALYST, 46, 4).addItemStacks(electrode);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 33).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
        IRecipeSlotBuilder fluidIn = builder.addSlot(RecipeIngredientRole.INPUT, 4, 19).setFluidRenderer(1000L, false, 16, 47).setOverlay(this.TANK, 0, 0);
        IRecipeSlotBuilder fluidOut = builder.addSlot(RecipeIngredientRole.OUTPUT, 126, 19).setFluidRenderer(1000L, false, 16, 47).setOverlay(this.TANK, 0, 0);
        if (recipe.input_fluid != null) {
            fluidIn.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.input_fluid.getMatchingFluidStacks());
        }
        if (recipe.output_fluid != null) {
            fluidOut.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.output_fluid);
        }
    }

    public void draw(ElectrolyzerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.ARROW.draw(guiGraphics, 71, 34);
    }

    public Component getTitle() {
        return LangUtil.translate("gui.jei.category.immersiveindustry.industrial_electrolyzer", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }
}

