/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ElectrolyzerRecipeSerializer
extends IERecipeSerializer<ElectrolyzerRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IIContent.IIBlocks.electrolyzer.get());
    }

    @Nullable
    public ElectrolyzerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack output = buffer.m_130267_();
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.m_130242_()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((FriendlyByteBuf)buffer);
        }
        FluidTagInput input_fluid = null;
        FluidStack output_fluid = null;
        if (buffer.readBoolean()) {
            input_fluid = FluidTagInput.read((FriendlyByteBuf)buffer);
        }
        if (buffer.readBoolean()) {
            output_fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        }
        int time = buffer.m_130242_();
        int tickEnergy = buffer.m_130242_();
        boolean flag = buffer.readBoolean();
        return new ElectrolyzerRecipe(recipeId, output, inputs, input_fluid, output_fluid, time, tickEnergy, flag);
    }

    public void toNetwork(FriendlyByteBuf buffer, ElectrolyzerRecipe recipe) {
        buffer.m_130055_(recipe.output);
        buffer.m_130130_(recipe.inputs.length);
        for (IngredientWithSize input : recipe.inputs) {
            input.write(buffer);
        }
        if (recipe.input_fluid != null) {
            buffer.writeBoolean(true);
            recipe.input_fluid.write(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        if (recipe.output_fluid != null) {
            buffer.writeBoolean(true);
            recipe.output_fluid.writeToPacket(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130130_(recipe.time);
        buffer.m_130130_(recipe.tickEnergy);
        buffer.writeBoolean(recipe.flag);
    }

    public ElectrolyzerRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        IngredientWithSize[] inputs;
        ItemStack output = (ItemStack)ElectrolyzerRecipeSerializer.readOutput((JsonElement)json.get("result")).get();
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = json.has("input") ? new IngredientWithSize[]{IngredientWithSize.deserialize((JsonElement)json.get("input"))} : new IngredientWithSize[]{};
        }
        FluidTagInput input_fluid = null;
        if (json.has("fluid")) {
            input_fluid = FluidTagInput.deserialize((JsonElement)json.get("fluid"));
        }
        int time = 200;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int tickEnergy = 32;
        if (json.has("tickEnergy")) {
            tickEnergy = json.get("tickEnergy").getAsInt();
        }
        boolean flag = false;
        if (json.has("large_only")) {
            flag = json.get("large_only").getAsBoolean();
        }
        FluidStack result_fluid = FluidStack.EMPTY;
        if (json.has("result_fluid")) {
            result_fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)json.get("result_fluid").getAsJsonObject());
        }
        return new ElectrolyzerRecipe(recipeId, output, inputs, input_fluid, result_fluid, time, tickEnergy, flag);
    }
}

