/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerBlockEntity;
import com.teammoeg.immersiveindustry.content.electrolyzer.IndustrialElectrolyzerState;
import com.teammoeg.immersiveindustry.util.FluidRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.FluidRecipeSimulator;
import com.teammoeg.immersiveindustry.util.ItemRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeSimulateHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.RegistryObject;

public class ElectrolyzerRecipe
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<ElectrolyzerRecipe>> SERIALIZER;
    public final IngredientWithSize[] inputs;
    public final FluidTagInput input_fluid;
    public final ItemStack output;
    public final FluidStack output_fluid;
    public final int time;
    public final int tickEnergy;
    public final boolean flag;
    public static CachedRecipeList<ElectrolyzerRecipe> recipeList;

    public ElectrolyzerRecipe(ResourceLocation id, ItemStack output, IngredientWithSize[] input, FluidTagInput input_fluid, FluidStack output_fluid, int time, int tickEnergy, boolean flag) {
        super(Lazy.of(() -> output), IIContent.IIRecipes.ELECTROLYZER, id);
        this.output = output;
        this.inputs = input;
        this.input_fluid = input_fluid;
        this.time = time;
        this.tickEnergy = tickEnergy;
        this.flag = flag;
        this.output_fluid = output_fluid;
    }

    protected IERecipeSerializer<ElectrolyzerRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return this.output;
    }

    public static boolean isValidRecipeInput(Level l, ItemStack input) {
        for (ElectrolyzerRecipe recipe : recipeList.getRecipes(l)) {
            for (IngredientWithSize is : recipe.inputs) {
                if (!is.testIgnoringSize(input)) continue;
                return true;
            }
        }
        return false;
    }

    public static RecipeProcessResult<ElectrolyzerRecipe> findRecipe(ElectrolyzerBlockEntity te) {
        return ElectrolyzerRecipe.findRecipe(te.m_58904_(), (ItemStack)te.inventory.get(0), ItemStack.f_41583_, (IFluidHandler)te.tank, false);
    }

    public static RecipeProcessResult<ElectrolyzerRecipe> findRecipe(IMultiblockContext<IndustrialElectrolyzerState> context) {
        return ElectrolyzerRecipe.findRecipe(context.getLevel().getRawLevel(), ((IndustrialElectrolyzerState)context.getState()).inventory.getStackInSlot(0), ((IndustrialElectrolyzerState)context.getState()).inventory.getStackInSlot(1), (IFluidHandler)((IndustrialElectrolyzerState)context.getState()).tank[0], true);
    }

    public static RecipeProcessResult<ElectrolyzerRecipe> findRecipe(Level l, ItemStack input, ItemStack input2, IFluidHandler input_fluid, boolean isLarge) {
        for (ElectrolyzerRecipe recipe : recipeList.getRecipes(l)) {
            RecipeProcessResult<ElectrolyzerRecipe> data = ElectrolyzerRecipe.test(recipe, input, input2, input_fluid, isLarge);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static RecipeProcessResult<ElectrolyzerRecipe> executeRecipe(Level l, ResourceLocation rl, ItemStack input, ItemStack input2, IFluidHandler input_fluid, boolean isLarge) {
        return ElectrolyzerRecipe.test((ElectrolyzerRecipe)recipeList.getById(l, rl), input, input2, input_fluid, isLarge);
    }

    public static RecipeProcessResult<ElectrolyzerRecipe> test(ElectrolyzerRecipe recipe, ItemStack input, ItemStack input2, IFluidHandler tanks, boolean isLarge) {
        int size = (input.m_41619_() ? 0 : 1) + (input2.m_41619_() ? 0 : 1);
        if (isLarge || !recipe.flag) {
            ItemRecipeProcessResult slotOps = null;
            if (recipe.inputs.length > 0) {
                if (recipe.inputs.length > size) {
                    return null;
                }
                RecipeSimulateHelper helper = new RecipeSimulateHelper(input, input2);
                slotOps = helper.simulateExtract(recipe.inputs);
                if (slotOps == null) {
                    return null;
                }
            }
            FluidRecipeProcessResult fluid = null;
            if (recipe.input_fluid != null && (fluid = FluidRecipeSimulator.test(tanks, recipe.input_fluid)) == null) {
                return null;
            }
            return new RecipeProcessResult<ElectrolyzerRecipe>(recipe, slotOps, fluid);
        }
        return null;
    }

    public static boolean isValidRecipeFluid(Level l, FluidStack input_fluid) {
        for (ElectrolyzerRecipe recipe : recipeList.getRecipes(l)) {
            if (recipe.input_fluid == null || !recipe.input_fluid.testIgnoringAmount(input_fluid)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (IngredientWithSize is : this.inputs) {
            nonnulllist.add((Object)is.getBaseIngredient());
        }
        return nonnulllist;
    }

    static {
        recipeList = new CachedRecipeList(IIContent.IIRecipes.ELECTROLYZER);
    }
}

