/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerBlockEntity;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.util.IIBaseContainer;
import com.teammoeg.immersiveindustry.util.IIContainerData;
import com.teammoeg.immersiveindustry.util.OutputSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ElectrolyzerContainer
extends IIBaseContainer {
    public MutableEnergyStorage energyStorage;
    public FluidTank tank;
    public final IIContainerData.CustomDataSlot<FluidStack> guiTank = IIContainerData.SLOT_TANK.create(this);
    public final IIContainerData.CustomDataSlot<Float> guiProgress = IIContainerData.SLOT_FIXED.create(this);
    public final IIContainerData.CustomDataSlot<Integer> energy = IIContainerData.SLOT_INT.create(this);

    public ElectrolyzerContainer(MenuType<?> type, int id, Inventory invPlayer, ElectrolyzerBlockEntity be) {
        this(type, id, invPlayer, (IItemHandlerModifiable)new ItemStackHandler(be.inventory));
        this.energyStorage = be.energyStorage;
        this.tank = be.tank;
        this.energy.bind(() -> ((MutableEnergyStorage)this.energyStorage).getEnergyStored());
        this.guiTank.bind(() -> ((FluidTank)this.tank).getFluid());
        this.guiProgress.bind(be::getGuiProgress);
    }

    public ElectrolyzerContainer(MenuType<?> type, int id, Inventory invPlayer) {
        this(type, id, invPlayer, (IItemHandlerModifiable)new ItemStackHandler(2));
        this.energyStorage = new MutableEnergyStorage(20000);
        this.tank = new FluidTank(8000);
        this.guiTank.bind(arg_0 -> ((FluidTank)this.tank).setFluid(arg_0));
        this.energy.bind(arg_0 -> ((MutableEnergyStorage)this.energyStorage).setStoredEnergy(arg_0));
    }

    protected ElectrolyzerContainer(MenuType<?> type, int id, Inventory invPlayer, IItemHandlerModifiable inv) {
        super(type, id, invPlayer.f_35978_, 2);
        final Level level = invPlayer.f_35978_.m_9236_();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 0, 51, 34){

            public boolean m_5857_(ItemStack stack) {
                return ElectrolyzerRecipe.isValidRecipeInput(level, stack);
            }
        });
        this.m_38897_((Slot)new OutputSlot(inv, 1, 107, 34));
        super.addPlayerInventory(invPlayer, 8, 84, 142);
    }
}

