/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.util.LangUtil;
import java.util.Arrays;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class ElectrolyzerCategory
implements IRecipeCategory<ElectrolyzerRecipe> {
    public static RecipeType<ElectrolyzerRecipe> UID = new RecipeType(new ResourceLocation("immersiveindustry", "electrolyzer"), ElectrolyzerRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;
    private IDrawable TANK;
    private IDrawableAnimated ARROW;

    public ElectrolyzerCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)IIContent.IIBlocks.electrolyzer.get()));
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/electrolyzer.png"), 17, 14, 115, 60);
        this.TANK = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/electrolyzer.png"), 197, 1, 18, 48);
        IDrawableStatic arrow = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/electrolyzer.png"), 178, 57, 21, 15);
        this.ARROW = guiHelper.createAnimatedDrawable(arrow, 20, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<ElectrolyzerRecipe> getRecipeType() {
        return UID;
    }

    public void draw(ElectrolyzerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.ARROW.draw(guiGraphics, 59, 21);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ElectrolyzerRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder fluidSlot = builder.addSlot(RecipeIngredientRole.INPUT, 4, 4).setFluidRenderer(50L, false, 16, 47).setOverlay(this.TANK, 0, 0);
        if (recipe.inputs.length > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 34, 20).addItemStacks(Arrays.asList(recipe.inputs[0].getMatchingStacks()));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 20).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
        if (recipe.input_fluid != null) {
            fluidSlot.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.input_fluid.getMatchingFluidStacks());
        }
    }

    public Component getTitle() {
        return LangUtil.translate("gui.jei.category.immersiveindustry.electrolyzer", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }
}

