/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.electrolyzer;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerBlock;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerContainer;
import com.teammoeg.immersiveindustry.content.electrolyzer.ElectrolyzerRecipe;
import com.teammoeg.immersiveindustry.util.LangUtil;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class ElectrolyzerBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEServerTickableBE,
IEBlockInterfaces.IProcessBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IConfigurableSides,
IEBlockInterfaces.IBlockOverlayText,
MenuProvider {
    public static final int NUM_SLOTS = 2;
    public static final int SLOT_IN = 0;
    public static final int SLOT_OUT = 1;
    public static final int ENERGY_CAPACITY = 20000;
    public static final int TANK_CAPACITY = 8000;
    public int process = 0;
    public int processMax = 0;
    public int tickEnergy = 0;
    public ItemStack result = ItemStack.f_41583_;
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(20000);
    private final ResettableCapability<IEnergyStorage> energyCap = this.registerEnergyInput((IEnergyStorage)this.energyStorage);
    public FluidTank tank = new FluidTank(8000, r -> ElectrolyzerRecipe.isValidRecipeFluid(this.m_58904_(), r));
    private final ResettableCapability<IFluidHandler> tankCap = this.registerFluidInput(new IFluidTank[]{this.tank});
    NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    ResettableCapability<IItemHandler> invHandler = this.registerCapability(new IEInventoryHandler(2, (IIEInventory)this, 0, new boolean[]{true, false}, new boolean[]{false, true}));
    public Map<Direction, IEEnums.IOSideConfig> sideConfig = new EnumMap<Direction, IEEnums.IOSideConfig>(Direction.class);

    public ElectrolyzerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IIContent.IITileTypes.ELECTROLYZER.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            if (d == Direction.UP) {
                this.sideConfig.put(d, IEEnums.IOSideConfig.NONE);
                continue;
            }
            this.sideConfig.put(d, IEEnums.IOSideConfig.INPUT);
        }
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom((EnergyStorage)this.energyStorage, (CompoundTag)nbt);
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.process = nbt.m_128451_("process");
        this.processMax = nbt.m_128451_("processMax");
        int[] sideConfigArray = nbt.m_128465_("sideConfig");
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.VALUES[sideConfigArray[d.ordinal()]]);
        }
        if (!descPacket) {
            this.result = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("result"));
            this.tickEnergy = nbt.m_128451_("tickEnergy");
            Collections.fill(this.inventory, ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo((EnergyStorage)this.energyStorage, (CompoundTag)nbt);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        nbt.m_128405_("process", this.process);
        nbt.m_128405_("processMax", this.processMax);
        int[] sideConfigArray = new int[6];
        for (Direction d : DirectionUtils.VALUES) {
            sideConfigArray[d.ordinal()] = this.sideConfig.get(d).ordinal();
        }
        nbt.m_128385_("sideConfig", sideConfigArray);
        if (!descPacket) {
            nbt.m_128365_("result", (Tag)this.result.serializeNBT());
            nbt.m_128405_("tickEnergy", this.tickEnergy);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    public void tickServer() {
        if (this.energyStorage.getEnergyStored() >= this.tickEnergy) {
            ElectrolyzerRecipe recipe;
            if (this.process > 0) {
                --this.process;
                this.energyStorage.extractEnergy(this.tickEnergy, false);
                this.m_6596_();
                return;
            }
            if (!this.result.m_41619_()) {
                if (((ItemStack)this.inventory.get(1)).m_41619_()) {
                    this.inventory.set(1, (Object)this.result);
                    this.result = ItemStack.f_41583_;
                    this.processMax = 0;
                    this.process = 0;
                    this.tickEnergy = 0;
                    this.m_6596_();
                } else if (((ItemStack)this.inventory.get(1)).m_150930_(this.result.m_41720_())) {
                    ((ItemStack)this.inventory.get(1)).m_41769_(this.result.m_41613_());
                    this.result = ItemStack.f_41583_;
                    this.processMax = 0;
                    this.process = 0;
                    this.tickEnergy = 0;
                    this.m_6596_();
                } else {
                    return;
                }
            }
            if ((recipe = this.getRecipe()) != null) {
                this.processMax = this.process = recipe.time;
                this.tickEnergy = (int)((double)recipe.tickEnergy * (Double)IIConfig.SERVER.electrolyzerBaseRate.get());
                if (recipe.inputs.length > 0) {
                    Utils.modifyInvStackSize(this.inventory, (int)0, (int)(-recipe.inputs[0].getCount()));
                }
                if (recipe.input_fluid != null) {
                    this.tank.drain(recipe.input_fluid.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
                this.result = recipe.output.m_41777_();
                this.m_6596_();
            }
        } else if (this.process > 0) {
            this.process = this.processMax;
            this.m_6596_();
        }
    }

    @Nullable
    public ElectrolyzerRecipe getRecipe() {
        RecipeProcessResult<ElectrolyzerRecipe> recipe = ElectrolyzerRecipe.findRecipe(this);
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(1)).m_41619_() || ItemStack.m_41656_((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)recipe.recipe().output) && ((ItemStack)this.inventory.get(1)).m_41613_() + recipe.recipe().output.m_41613_() <= this.getSlotLimit(1)) {
            return recipe.recipe();
        }
        return null;
    }

    public int[] getCurrentProcessesStep() {
        return new int[]{this.processMax - this.process};
    }

    public int[] getCurrentProcessesMax() {
        return new int[]{this.processMax};
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction facing) {
        if (facing != null) {
            if (capability == ForgeCapabilities.ENERGY) {
                return this.energyCap.cast();
            }
            if (capability == ForgeCapabilities.FLUID_HANDLER && this.sideConfig.get(facing) == IEEnums.IOSideConfig.INPUT) {
                return this.tankCap.cast();
            }
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.invHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public IEEnums.IOSideConfig getSideConfig(@Nullable Direction facing) {
        return this.sideConfig.get(facing);
    }

    public boolean toggleSide(Direction side, Player p) {
        if (side != Direction.UP) {
            this.sideConfig.put(side, IEEnums.IOSideConfig.next((IEEnums.IOSideConfig)this.sideConfig.get(side)));
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            this.getLevelNonnull().m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
            return true;
        }
        return false;
    }

    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (hammer && ((Boolean)IEClientConfig.showTextOverlay.get()).booleanValue() && mop instanceof BlockHitResult) {
            BlockHitResult brtr = (BlockHitResult)mop;
            IEEnums.IOSideConfig i = this.sideConfig.get(brtr.m_82434_());
            IEEnums.IOSideConfig j = this.sideConfig.get(brtr.m_82434_().m_122424_());
            return TextUtils.sideConfigWithOpposite((String)"desc.immersiveengineering.info.blockSide.connectFluid.", (StringRepresentable)i, (StringRepresentable)j);
        }
        return null;
    }

    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Nullable
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
    }

    public Property<Direction> getFacingProperty() {
        return ElectrolyzerBlock.FACING;
    }

    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    public float getGuiProgress() {
        float progress = 0.0f;
        if (this.processMax != 0) {
            progress = Mth.m_14036_((float)(1.0f - (float)this.process * 1.0f / (float)this.processMax), (float)0.0f, (float)1.0f);
        }
        return progress;
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ElectrolyzerContainer((MenuType)IIContent.IIMenus.ELECTROLYZER.get(), pContainerId, pPlayerInventory, this);
    }

    public Component m_5446_() {
        return LangUtil.translate("block.immersiveindustry.electrolyzer", new Object[0]);
    }
}

