/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.ICommonMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleLogic;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.RangedCheckedInputWrapper;
import com.teammoeg.immersiveindustry.util.RangedOutputWrapper;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class CrucibleState
implements IMultiblockState {
    ChangeDetectedItemHandler inventory;
    RecipeHandler<CrucibleRecipe> recipe;
    public int temperature;
    public int burnTime;
    public int burnTimeMax;
    public FluidTank tank = new FluidTank(14400);
    boolean active;
    boolean hasPreheater;
    BooleanSupplier isSoundPlaying = () -> false;
    StoredCapability<IItemHandler> inputHandler;
    StoredCapability<IItemHandler> fuelHandler;
    StoredCapability<IItemHandler> outputHandler;
    StoredCapability<IFluidHandler> outputFluidHandler;
    CapabilityReference<IFluidHandler> outputFluidCap;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public CrucibleState(IInitialMultiblockContext<CrucibleState> capabilitySource) {
        @Nullable Supplier level = capabilitySource.levelSupplier();
        this.recipe = new RecipeHandler<CrucibleRecipe>((r, t) -> t.time);
        this.inventory = new ChangeDetectedItemHandler(6, capabilitySource.getMarkDirtyRunnable());
        this.inventory.addSlotListener(0, 4, this.recipe::onContainerChanged);
        this.inputHandler = new StoredCapability((Object)new RangedCheckedInputWrapper((IItemHandlerModifiable)this.inventory, 0, 4, (arg_0, arg_1) -> CrucibleState.lambda$new$2((Supplier)level, arg_0, arg_1)));
        this.fuelHandler = new StoredCapability((Object)new RangedCheckedInputWrapper((IItemHandlerModifiable)this.inventory, 4, 5, (arg_0, arg_1) -> CrucibleState.lambda$new$3((Supplier)level, arg_0, arg_1)));
        this.outputHandler = new StoredCapability((Object)new RangedOutputWrapper((IItemHandlerModifiable)this.inventory, 5, 6));
        this.outputFluidHandler = new StoredCapability((Object)ArrayFluidHandler.drainOnly((IFluidTank)this.tank, (Runnable)capabilitySource.getMarkDirtyRunnable()));
        this.outputFluidCap = CrucibleLogic.fluidout.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.FLUID_HANDLER);
    }

    public float getBurnProgress() {
        return this.burnTimeMax == 0 ? 0.0f : (float)this.burnTime / (float)this.burnTimeMax;
    }

    public void writeSaveNBT(CompoundTag nbt) {
        nbt.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        this.recipe.writeCustomNBT(nbt, false);
        nbt.m_128405_("temperature", this.temperature);
        nbt.m_128405_("burntime", this.burnTime);
        nbt.m_128405_("burnTimeMax", this.burnTimeMax);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public void readSaveNBT(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        this.recipe.readCustomNBT(nbt, false);
        this.temperature = nbt.m_128451_("temperature");
        this.burnTime = nbt.m_128451_("burntime");
        this.burnTimeMax = nbt.m_128451_("burnTimeMax");
        this.tank.readFromNBT(nbt.m_128469_("tank"));
    }

    public void writeSyncNBT(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
    }

    public void readSyncNBT(CompoundTag nbt) {
        this.active = nbt.m_128471_("active");
    }

    private static /* synthetic */ boolean lambda$new$3(Supplier level, Integer i, ItemStack r) {
        return CrucibleRecipe.getFuelTime((Level)level.get(), r) > 0;
    }

    private static /* synthetic */ boolean lambda$new$2(Supplier level, Integer i, ItemStack r) {
        return CrucibleRecipe.isValidInput((Level)level.get(), r);
    }
}

