/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleContainer;
import com.teammoeg.immersiveindustry.util.AccessableFluidInfoArea;
import com.teammoeg.immersiveindustry.util.IIContainerScreen;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.IFluidTank;

public class CrucibleScreen
extends IIContainerScreen<CrucibleContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("immersiveindustry", "textures/gui/crucible.png");

    public CrucibleScreen(CrucibleContainer container, Inventory inv, Component title) {
        super(container, inv, title, TEXTURE);
    }

    @Override
    protected void makeInfoAreas() {
        this.addInfoArea((InfoArea)new AccessableFluidInfoArea((IFluidTank)((CrucibleContainer)this.f_97732_).tank, new Rect2i(this.f_97735_ + 145, this.f_97736_ + 12, 16, 47), 236, 32, 20, 51, TEXTURE));
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (mouseX >= this.f_97735_ + 10 && mouseX < this.f_97735_ + 19 && mouseY > this.f_97736_ + 10 && mouseY < this.f_97736_ + 67) {
            int k = ((CrucibleContainer)this.f_97732_).temperature.getValue();
            addLine.accept((Component)Component.m_237110_((String)"gui.immersiveindustry.crucible.temperature_in_celsius", (Object[])new Object[]{k}));
        }
    }

    @Override
    protected void drawContainerBackgroundPre(GuiGraphics graphics, float partialTicks, int x, int y) {
        float process;
        float burnTime;
        int temp = ((CrucibleContainer)this.f_97732_).temperature.getValue();
        if (temp > 0) {
            int bar = temp / 30;
            graphics.m_280218_(TEXTURE, this.f_97735_ + 12, this.f_97736_ + 67 - bar, 177, 83 - bar, 5, bar);
        }
        if ((burnTime = ((CrucibleContainer)this.f_97732_).fuelProcess.getValue().floatValue()) > 0.0f) {
            int h = (int)(burnTime * 12.0f);
            graphics.m_280218_(TEXTURE, this.f_97735_ + 84, this.f_97736_ + 47 - h, 179, 13 - h, 9, h);
        }
        if ((process = ((CrucibleContainer)this.f_97732_).process.getValue().floatValue()) > 0.0f) {
            int h = (int)(21.0f * process);
            graphics.m_280218_(TEXTURE, this.f_97735_ + 76, this.f_97736_ + 14, 204, 15, h, 15);
        }
        if (((CrucibleContainer)this.f_97732_).hasPreheater.getValue().booleanValue()) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 28, this.f_97736_ + 54, 199, 32, 12, 11);
        }
    }
}

