/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleRecipeSerializer
extends IERecipeSerializer<CrucibleRecipe> {
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IIContent.IIMultiblocks.CRUCIBLE.blockItem().get());
    }

    public CrucibleRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext ctx) {
        IngredientWithSize[] inputs;
        Lazy output = CrucibleRecipeSerializer.readOutput((JsonElement)json.get("result"));
        if (json.has("inputs")) {
            JsonArray ja = json.get("inputs").getAsJsonArray();
            inputs = new IngredientWithSize[ja.size()];
            int i = -1;
            for (JsonElement je : ja) {
                inputs[++i] = IngredientWithSize.deserialize((JsonElement)je);
            }
        } else {
            inputs = new IngredientWithSize[]{};
        }
        FluidStack result_fluid = FluidStack.EMPTY;
        if (json.has("result_fluid")) {
            result_fluid = ApiUtils.jsonDeserializeFluidStack((JsonObject)json.getAsJsonObject("result_fluid"));
        }
        int time = 400;
        if (json.has("time")) {
            time = json.get("time").getAsInt();
        }
        int temperature = 0;
        if (json.has("temperature")) {
            temperature = json.get("temperature").getAsInt();
        }
        if (inputs == null || inputs.length == 0) {
            throw new RuntimeException("Error loading crucible recipe " + recipeId + " because no input found");
        }
        if (((ItemStack)output.get()).m_41619_() && result_fluid.isEmpty()) {
            throw new RuntimeException("Error loading crucible recipe " + recipeId + " because no output found");
        }
        return new CrucibleRecipe(recipeId, (Lazy<ItemStack>)output, result_fluid, inputs, time, temperature);
    }

    @Nullable
    public CrucibleRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack output = buffer.m_130267_();
        IngredientWithSize[] inputs = new IngredientWithSize[buffer.m_130242_()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = IngredientWithSize.read((FriendlyByteBuf)buffer);
        }
        FluidStack output_fluid = null;
        if (buffer.readBoolean()) {
            output_fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        }
        int time = buffer.readInt();
        int temperature = buffer.readInt();
        return new CrucibleRecipe(recipeId, (Lazy<ItemStack>)Lazy.of(() -> output), output_fluid, inputs, time, temperature);
    }

    public void toNetwork(FriendlyByteBuf buffer, CrucibleRecipe recipe) {
        buffer.m_130055_((ItemStack)recipe.output.get());
        buffer.m_130130_(recipe.inputs.length);
        for (IngredientWithSize input : recipe.inputs) {
            input.write(buffer);
        }
        if (recipe.output_fluid != null) {
            buffer.writeBoolean(true);
            recipe.output_fluid.writeToPacket(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(recipe.time);
        buffer.writeInt(recipe.temperature);
    }
}

