/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceFuel;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleState;
import com.teammoeg.immersiveindustry.util.ItemRecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import com.teammoeg.immersiveindustry.util.RecipeSimulateHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryObject;

public class CrucibleRecipe
extends IESerializableRecipe {
    public static RegistryObject<IERecipeSerializer<CrucibleRecipe>> SERIALIZER;
    public static CachedRecipeList<CrucibleRecipe> recipeList;
    public final IngredientWithSize[] inputs;
    public final Lazy<ItemStack> output;
    public final FluidStack output_fluid;
    public final int time;
    public final int temperature;

    public CrucibleRecipe(ResourceLocation id, Lazy<ItemStack> output2, FluidStack output_fluid, IngredientWithSize[] input, int time, int temperature) {
        super(output2, IIContent.IIRecipes.CRUCIBLE, id);
        this.output = output2;
        this.output_fluid = output_fluid;
        this.inputs = input;
        this.time = time;
        this.temperature = temperature;
    }

    protected IERecipeSerializer getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return (ItemStack)this.output.get();
    }

    public static boolean isValidInput(Level l, ItemStack stack) {
        for (CrucibleRecipe recipe : recipeList.getRecipes(l)) {
            for (IngredientWithSize is : recipe.inputs) {
                if (!is.testIgnoringSize(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFuelTime(Level l, ItemStack stack) {
        return BlastFurnaceFuel.getBlastFuelTime((Level)l, (ItemStack)stack);
    }

    public static RecipeProcessResult<CrucibleRecipe> findRecipe(IMultiblockContext<CrucibleState> context) {
        return CrucibleRecipe.findRecipe(context.getLevel().getRawLevel(), (IItemHandler)((CrucibleState)context.getState()).inventory);
    }

    public static RecipeProcessResult<CrucibleRecipe> findRecipe(Level l, IItemHandler handler) {
        for (CrucibleRecipe recipe : recipeList.getRecipes(l)) {
            RecipeProcessResult<CrucibleRecipe> data = CrucibleRecipe.test(recipe, handler);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public static RecipeProcessResult<CrucibleRecipe> executeRecipe(Level l, ResourceLocation rl, IItemHandler handler) {
        return CrucibleRecipe.test((CrucibleRecipe)recipeList.getById(l, rl), handler);
    }

    public static RecipeProcessResult<CrucibleRecipe> test(CrucibleRecipe recipe, IItemHandler handler) {
        int size = 0;
        for (int i = 0; i < 4; ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            ++size;
        }
        ItemRecipeProcessResult slotOps = null;
        if (recipe.inputs.length > 0) {
            if (recipe.inputs.length > size) {
                return null;
            }
            RecipeSimulateHelper helper = new RecipeSimulateHelper(handler, 0, 4);
            slotOps = helper.simulateExtract(recipe.inputs);
            if (slotOps == null) {
                return null;
            }
        }
        return new RecipeProcessResult<CrucibleRecipe>(recipe, slotOps);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (IngredientWithSize is : this.inputs) {
            nonnulllist.add((Object)is.getBaseIngredient());
        }
        return nonnulllist;
    }

    static {
        recipeList = new CachedRecipeList(IIContent.IIRecipes.CRUCIBLE);
    }
}

