/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import com.teammoeg.immersiveindustry.IIConfig;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleState;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.IIUtil;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import com.teammoeg.immersiveindustry.util.RecipeProcessResult;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class CrucibleLogic
implements IClientTickableComponent<CrucibleState>,
IMultiblockLogic<CrucibleState>,
IServerTickableComponent<CrucibleState> {
    public static final int MAX_TEMP = 1700;
    public static final int TEMP_ABOVE_WHICH_REQUIRES_FANS = 1000;
    public static final BlockPos FRONT_PREHEATER_REL_POS = new BlockPos(1, 0, -1);
    public static final BlockPos BACK_PREHEATER_REL_POS = new BlockPos(1, 0, 3);
    public static final int DEFAULT_ACTIVE_FAN_SPEED = 64;
    static final CapabilityFacing fluidout = new CapabilityFacing(2, 1, 2, RelativeBlockFace.UP);
    static final Function<BlockPos, VoxelShape> shapeCache = Util.m_143827_(CrucibleLogic::getShape);

    public void ensureBurntime(IMultiblockContext<CrucibleState> context) {
        int totalTime;
        CrucibleState state = (CrucibleState)context.getState();
        ChangeDetectedItemHandler inventory = state.inventory;
        if (state.burnTime <= 0 && !inventory.getStackInSlot(4).m_41619_() && (totalTime = CrucibleRecipe.getFuelTime(context.getLevel().getRawLevel(), inventory.getStackInSlot(4))) > 0) {
            state.burnTime = totalTime;
            state.burnTimeMax = totalTime;
            ItemStack origin = inventory.getStackInSlot(4);
            if (origin.m_41613_() == 1) {
                inventory.setStackInSlotNoChange(4, ItemStack.f_41583_);
            } else {
                inventory.setStackInSlotNoChange(4, origin.m_255036_(origin.m_41613_() - 1));
            }
            context.markMasterDirty();
        }
    }

    public void tickServer(IMultiblockContext<CrucibleState> context) {
        this.tryOutput(context);
        CrucibleState state = (CrucibleState)context.getState();
        ChangeDetectedItemHandler inventory = state.inventory;
        RandomSource rs = context.getLevel().getRawLevel().f_46441_;
        boolean lastIsActive = state.active;
        state.active = false;
        this.ensureBurntime(context);
        if (state.temperature > 0) {
            state.temperature -= IIUtil.randomValue(rs, (Double)IIConfig.SERVER.crucibleCoolDown.get());
            context.markMasterDirty();
        }
        if (state.burnTime > 0) {
            double coefficient;
            int prevTemp = state.temperature;
            int fanspeed = this.getFanSpeed(context);
            double d = coefficient = fanspeed < 64 ? 0.0 : Math.sqrt(fanspeed) / 8.0;
            if (coefficient == 0.0) {
                if (state.temperature > 1000) {
                    --state.temperature;
                } else {
                    state.active = true;
                    --state.burnTime;
                    ++state.temperature;
                }
            } else if (state.temperature < 1700) {
                state.active = true;
                --state.burnTime;
                ++state.temperature;
                if (Math.random() + Math.random() < coefficient) {
                    ++state.temperature;
                }
                if (Math.random() + Math.random() + Math.random() < coefficient) {
                    ++state.temperature;
                }
            }
            if (state.temperature != prevTemp) {
                state.recipe.onContainerChanged();
            }
            context.markMasterDirty();
        }
        state.temperature = Mth.m_14045_((int)state.temperature, (int)0, (int)1700);
        RecipeHandler<CrucibleRecipe> handler = state.recipe;
        if (handler.shouldTestRecipe()) {
            RecipeProcessResult<CrucibleRecipe> recipeResult = CrucibleRecipe.findRecipe(context);
            handler.setRecipe(recipeResult);
            context.markMasterDirty();
        }
        if (handler.shouldTickProcess()) {
            this.ensureBurntime(context);
            CrucibleRecipe rcp = (CrucibleRecipe)CrucibleRecipe.recipeList.getById(context.getLevel().getRawLevel(), handler.getLastRecipe());
            if (state.temperature >= rcp.temperature && state.burnTime > 0 && handler.tickProcess(1)) {
                --state.burnTime;
                state.active = true;
            }
            if (handler.isRecipeFinished()) {
                RecipeProcessResult<CrucibleRecipe> recipeResult = handler.getRecipeResultCache();
                if (recipeResult != null) {
                    CrucibleRecipe recipe = recipeResult.recipe();
                    if (inventory.insertItem(5, (ItemStack)recipe.output.get(), true).m_41619_() && state.tank.fill(recipe.output_fluid, IFluidHandler.FluidAction.SIMULATE) >= recipe.output_fluid.getAmount()) {
                        inventory.insertItem(5, ((ItemStack)recipe.output.get()).m_41777_(), false);
                        state.tank.fill(recipe.output_fluid, IFluidHandler.FluidAction.EXECUTE);
                        handler.endProcess();
                        recipeResult.runOperations((IItemHandlerModifiable)inventory, null);
                    }
                } else {
                    handler.endProcess();
                }
            }
            context.markMasterDirty();
        }
        if (state.active != lastIsActive) {
            NonMirrorableWithActiveBlock.setActive((IMultiblockLevel)context.getLevel(), (TemplateMultiblock)((TemplateMultiblock)IIContent.IIMultiblocks.Multiblock.CRUCIBLE.get()), (boolean)state.active);
        }
    }

    public CrucibleState createInitialState(IInitialMultiblockContext<CrucibleState> capabilitySource) {
        return new CrucibleState(capabilitySource);
    }

    static VoxelShape getShape(BlockPos pos) {
        if (pos.m_123341_() == 1 && pos.m_123343_() == 1) {
            return Shapes.m_83144_();
        }
        double minX = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxZ = 1.0;
        double minSideX = 0.0;
        double minSideZ = 0.0;
        double maxSideX = 1.0;
        double maxSideZ = 1.0;
        double minorNum = 0.375;
        double bottomY = 0.0;
        double sideGrow = 0.1875;
        switch (pos.m_123342_()) {
            case 2: {
                minorNum = 0.125;
                break;
            }
            case 0: {
                bottomY = 0.125;
                sideGrow = 0.125;
            }
            case 1: {
                minorNum = 0.25;
            }
        }
        if (pos.m_123341_() == 2) {
            maxX = 1.0 - minorNum;
            maxSideX = maxX + sideGrow;
        } else if (pos.m_123341_() == 0) {
            minX = minorNum;
            minSideX = minX - sideGrow;
        }
        if (pos.m_123343_() == 0) {
            minZ = minorNum;
            minSideZ = minZ - sideGrow;
        } else if (pos.m_123343_() == 2) {
            maxZ = 1.0 - minorNum;
            maxSideZ = maxZ + sideGrow;
        }
        VoxelShape pillar = Shapes.m_83040_();
        double pillarY = 1.0;
        if (pos.m_123342_() == 3) {
            pillarY = 0.0625;
        }
        if (pos.m_123341_() == 0) {
            if (pos.m_123343_() == 0) {
                pillar = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.625, (double)pillarY, (double)0.625);
            } else if (pos.m_123343_() == 2) {
                pillar = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.375, (double)0.625, (double)pillarY, (double)1.0);
            }
        }
        if (pos.m_123341_() == 2) {
            if (pos.m_123343_() == 0) {
                pillar = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.0, (double)1.0, (double)pillarY, (double)0.625);
            } else if (pos.m_123343_() == 2) {
                pillar = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)1.0, (double)pillarY, (double)1.0);
            }
        }
        VoxelShape base = Shapes.m_83110_((VoxelShape)pillar, (VoxelShape)Shapes.m_83048_((double)minX, (double)bottomY, (double)minZ, (double)maxX, (double)1.0, (double)maxZ));
        if (pos.m_123342_() == 1) {
            base = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)minSideX, (double)0.5, (double)minSideZ, (double)maxSideX, (double)1.0, (double)maxSideZ), (VoxelShape)base);
        }
        if (pos.m_123342_() == 0) {
            base = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)minSideX, (double)0.125, (double)minSideZ, (double)maxSideX, (double)0.5, (double)maxSideZ), (VoxelShape)base);
        }
        if (pos.m_123341_() == 1 && pos.m_123342_() == 0 && pos.m_123343_() == 0) {
            base = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375), (VoxelShape)base);
        }
        return base;
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return shapeCache;
    }

    public void tickClient(IMultiblockContext<CrucibleState> context) {
        RandomSource random = context.getLevel().getRawLevel().f_46441_;
        Level world = context.getLevel().getRawLevel();
        BlockPos pos = context.getLevel().toAbsolute(IIContent.IIMultiblocks.CRUCIBLE.masterPosInMB());
        if (((CrucibleState)context.getState()).active && random.m_188501_() < 0.1f) {
            for (int i = 0; i < random.m_188503_(2) + 2; ++i) {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123778_, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.05, 0.0);
                world.m_7107_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.25 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.25 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), 0.002, 0.01, 0.0);
            }
        }
        CrucibleState state = (CrucibleState)context.getState();
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, (BooleanSupplier)context.isValid(), (Vec3)soundPos, (RegistryObject)IESounds.arcFurnace, (float)0.075f);
        }
    }

    public <T> LazyOptional<T> getCapability(IMultiblockContext<CrucibleState> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (position.posInMultiblock().m_123342_() <= 1) {
                return ((CrucibleState)ctx.getState()).fuelHandler.cast(ctx);
            }
            if (position.side() == RelativeBlockFace.UP) {
                return ((CrucibleState)ctx.getState()).inputHandler.cast(ctx);
            }
            return ((CrucibleState)ctx.getState()).outputHandler.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && fluidout.isCapabilityPosition(position)) {
            return ((CrucibleState)ctx.getState()).outputFluidHandler.cast(ctx);
        }
        return LazyOptional.empty();
    }

    public void onEntityCollision(IMultiblockContext<CrucibleState> ctx, BlockPos posInMultiblock, Entity collided) {
        if (posInMultiblock.m_123342_() >= 2) {
            if (!(collided instanceof ItemEntity)) {
                if (collided instanceof LivingEntity) {
                    LivingEntity col = (LivingEntity)collided;
                    if (((CrucibleState)ctx.getState()).temperature > 100) {
                        col.m_6469_(ctx.getLevel().getRawLevel().m_269111_().m_269047_(), 4.0f);
                    }
                }
                return;
            }
            ItemEntity itemEntity = (ItemEntity)collided;
            if (!itemEntity.m_213877_()) {
                ItemStack insertItem = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)((CrucibleState)ctx.getState()).inputHandler.getValue()), (ItemStack)itemEntity.m_32055_().m_41777_(), (boolean)false);
                if (insertItem.m_41619_()) {
                    itemEntity.m_32045_(ItemStack.f_41583_);
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                itemEntity.m_32045_(insertItem);
            }
        }
    }

    public boolean tryOutput(IMultiblockContext<CrucibleState> context) {
        CrucibleState state = (CrucibleState)context.getState();
        boolean update = FluidUtils.multiblockFluidOutput(state.outputFluidCap, (FluidTank)state.tank, (int)0, (int)0, null);
        return update;
    }

    public int getFromPreheater(IMultiblockContext<CrucibleState> context, Function<BlastFurnacePreheaterBlockEntity, Integer> getter, int orElse) {
        Optional<BlastFurnacePreheaterBlockEntity> preheater1 = Optional.empty();
        Optional<BlastFurnacePreheaterBlockEntity> preheater2 = Optional.empty();
        BlockEntity te1 = context.getLevel().getBlockEntity(FRONT_PREHEATER_REL_POS);
        BlockEntity te2 = context.getLevel().getBlockEntity(BACK_PREHEATER_REL_POS);
        if (te1 instanceof BlastFurnacePreheaterBlockEntity && ((BlastFurnacePreheaterBlockEntity)te1).getFacing().equals((Object)context.getLevel().getOrientation().front().m_122424_())) {
            preheater1 = Optional.of((BlastFurnacePreheaterBlockEntity)te1);
        }
        if (te2 instanceof BlastFurnacePreheaterBlockEntity && ((BlastFurnacePreheaterBlockEntity)te2).getFacing().equals((Object)context.getLevel().getOrientation().front())) {
            preheater2 = Optional.of((BlastFurnacePreheaterBlockEntity)te2);
        }
        int result1 = preheater1.map(getter).orElse(orElse);
        int result2 = preheater2.map(getter).orElse(orElse);
        return result1 + result2;
    }

    public int getFanSpeed(IMultiblockContext<CrucibleState> context) {
        boolean hasPreheater = this.getFromPreheater(context, BlastFurnacePreheaterBlockEntity::doSpeedup, 0) > 0;
        int fanSpeed = 0;
        if (hasPreheater) {
            fanSpeed = 64;
        }
        if (hasPreheater != ((CrucibleState)context.getState()).hasPreheater) {
            ((CrucibleState)context.getState()).hasPreheater = hasPreheater;
            context.markDirtyAndSync();
        }
        return fanSpeed;
    }

    public void dropExtraItems(CrucibleState state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }
}

