/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleState;
import com.teammoeg.immersiveindustry.util.IIBaseContainer;
import com.teammoeg.immersiveindustry.util.IIContainerData;
import com.teammoeg.immersiveindustry.util.OutputSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CrucibleContainer
extends IIBaseContainer {
    IIContainerData.CustomDataSlot<Float> process = IIContainerData.SLOT_FIXED.create(this);
    IIContainerData.CustomDataSlot<Float> fuelProcess = IIContainerData.SLOT_FIXED.create(this);
    IIContainerData.CustomDataSlot<Integer> temperature = IIContainerData.SLOT_INT.create(this);
    IIContainerData.CustomDataSlot<FluidStack> tankSlot = IIContainerData.SLOT_TANK.create(this);
    IIContainerData.CustomDataSlot<Boolean> hasPreheater = IIContainerData.SLOT_BOOL.create(this);
    FluidTank tank;

    public CrucibleContainer(MenuType<CrucibleContainer> type, int windowId, Inventory inventoryPlayer, IEContainerMenu.MultiblockMenuContext<CrucibleState> te) {
        super(type, windowId, inventoryPlayer.f_35978_, 6);
        CrucibleState state = (CrucibleState)te.mbContext().getState();
        this.process.bind(() -> Float.valueOf(state.recipe.getProgressRatio()));
        this.fuelProcess.bind(state::getBurnProgress);
        this.temperature.bind(() -> state.temperature);
        this.tank = state.tank;
        this.tankSlot.bind(() -> this.tank.getFluid());
        this.hasPreheater.bind(() -> state.hasPreheater);
        this.addSlots((IItemHandlerModifiable)state.inventory, inventoryPlayer);
    }

    public CrucibleContainer(MenuType<CrucibleContainer> type, int windowId, Inventory inventoryPlayer) {
        super(type, windowId, inventoryPlayer.f_35978_, 6);
        this.addSlots((IItemHandlerModifiable)new ItemStackHandler(6), inventoryPlayer);
        this.tank = new FluidTank(14400);
        this.tankSlot.bind(t -> this.tank.setFluid(t));
    }

    public void addSlots(IItemHandlerModifiable inv, Inventory inventoryPlayer) {
        final Level l = inventoryPlayer.f_35978_.m_9236_();
        this.m_38897_((Slot)new CrucibleSlot((IItemHandler)inv, 0, 30, 12, l));
        this.m_38897_((Slot)new CrucibleSlot((IItemHandler)inv, 1, 51, 12, l));
        this.m_38897_((Slot)new CrucibleSlot((IItemHandler)inv, 2, 30, 33, l));
        this.m_38897_((Slot)new CrucibleSlot((IItemHandler)inv, 3, 51, 33, l));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inv, 4, 80, 51){

            public boolean m_5857_(ItemStack itemStack) {
                return CrucibleRecipe.getFuelTime(l, itemStack) > 0;
            }
        });
        this.m_38897_((Slot)new OutputSlot(inv, 5, 109, 12));
        super.addPlayerInventory(inventoryPlayer, 8, 84, 142);
    }

    static class CrucibleSlot
    extends SlotItemHandler {
        Level l;

        public CrucibleSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Level l) {
            super(itemHandler, index, xPosition, yPosition);
            this.l = l;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return CrucibleRecipe.isValidInput(this.l, itemStack);
        }
    }
}

