/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.crucible;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import com.teammoeg.immersiveindustry.IIContent;
import com.teammoeg.immersiveindustry.content.crucible.CrucibleRecipe;
import com.teammoeg.immersiveindustry.util.JEISlotBuilder;
import com.teammoeg.immersiveindustry.util.LangUtil;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleCategory
implements IRecipeCategory<CrucibleRecipe> {
    public static RecipeType<CrucibleRecipe> UID = new RecipeType(new ResourceLocation("immersiveindustry", "crucible"), CrucibleRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;
    private IDrawable TANK;
    private IDrawableAnimated ARROW;

    public CrucibleCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)IIContent.IIMultiblocks.CRUCIBLE.blockItem().get()));
        this.BACKGROUND = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/crucible_jei.png"), 19, 3, 150, 65);
        this.TANK = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/crucible.png"), 238, 34, 18, 48);
        IDrawableStatic arrow = guiHelper.createDrawable(new ResourceLocation("immersiveindustry", "textures/gui/crucible.png"), 204, 15, 21, 15);
        this.ARROW = guiHelper.createAnimatedDrawable(arrow, 40, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CrucibleRecipe> getRecipeType() {
        return UID;
    }

    public Component getTitle() {
        return LangUtil.translate("gui.jei.category.immersiveindustry.crucible", new Object[0]);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void draw(CrucibleRecipe recipe, IRecipeSlotsView view, GuiGraphics transform, double mouseX, double mouseY) {
        this.ARROW.draw(transform, 57, 11);
        int k = recipe.temperature;
        String temperature = LangUtil.translate("gui.immersiveindustry.crucible.temperature_in_celsius", k).getString();
        transform.m_280488_(ClientUtils.font(), temperature, 45, 52, 14833698);
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, CrucibleRecipe recipe, IFocusGroup ingredients) {
        IRecipeSlotBuilder fluidOut = recipeLayout.addSlot(RecipeIngredientRole.INPUT, 126, 9).setFluidRenderer(14400L, false, 16, 47).setOverlay(this.TANK, 0, 0);
        if (recipe.output_fluid != FluidStack.EMPTY) {
            fluidOut.addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.output_fluid);
        }
        JEISlotBuilder<ItemStack> itemInput = JEISlotBuilder.itemStack(recipeLayout, JEIIngredientStackListBuilder.make((IngredientWithSize[])recipe.inputs).build()).asInput();
        itemInput.addSlot(11, 9);
        itemInput.addSlot(32, 9);
        itemInput.addSlot(11, 30);
        itemInput.addSlot(32, 30);
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 90, 9).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
    }
}

