/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.immersiveindustry.content.chemical_reactor;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.ICommonMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalLogic;
import com.teammoeg.immersiveindustry.content.chemical_reactor.ChemicalRecipe;
import com.teammoeg.immersiveindustry.util.CapabilityFacing;
import com.teammoeg.immersiveindustry.util.CapabilityProcessor;
import com.teammoeg.immersiveindustry.util.ChangeDetectedItemHandler;
import com.teammoeg.immersiveindustry.util.MultipleTankHandler;
import com.teammoeg.immersiveindustry.util.RangedCheckedInputWrapper;
import com.teammoeg.immersiveindustry.util.RangedOutputWrapper;
import com.teammoeg.immersiveindustry.util.RecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class ChemicalState
implements IMultiblockState {
    ChangeDetectedItemHandler inventory;
    FluidTank[] inTank = new FluidTank[]{new RecipeResetFluidTank(7000), new RecipeResetFluidTank(7000), new RecipeResetFluidTank(7000)};
    FluidTank[] outTank = new FluidTank[]{new RecipeResetFluidTank(7000), new RecipeResetFluidTank(7000), new RecipeResetFluidTank(7000)};
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(32000);
    RecipeHandler<ChemicalRecipe> recipe;
    boolean active;
    BooleanSupplier isSoundPlaying = () -> false;
    final StoredCapability<IItemHandler> inputHandler;
    final IItemHandler outputHandler;
    final MultipleTankHandler recipeOutputFluidHandler = new MultipleTankHandler(this.outTank);
    final MultipleTankHandler recipeInputFluidHandler = new MultipleTankHandler(this.inTank);
    List<CapabilityReference<IFluidHandler>> outputFluidCap = new ArrayList<CapabilityReference<IFluidHandler>>();
    CapabilityReference<IItemHandler> outputItemCap;
    CapabilityProcessor capabilities = new CapabilityProcessor();
    public RedstoneControl.RSState state = RedstoneControl.RSState.enabledByDefault();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ChemicalState(IInitialMultiblockContext<ChemicalState> capabilitySource) {
        @Nullable Supplier level = capabilitySource.levelSupplier();
        this.recipe = new RecipeHandler<ChemicalRecipe>((r, t) -> t.time);
        this.inventory = new ChangeDetectedItemHandler(6, capabilitySource.getMarkDirtyRunnable());
        this.inventory.addSlotListener(0, 3, this.recipe::onContainerChanged);
        this.inputHandler = new StoredCapability((Object)new RangedCheckedInputWrapper((IItemHandlerModifiable)this.inventory, 0, 3, (arg_0, arg_1) -> ChemicalState.lambda$new$2((Supplier)level, arg_0, arg_1)));
        this.outputHandler = new RangedOutputWrapper((IItemHandlerModifiable)this.inventory, 3, 6);
        int num = 0;
        CapabilityProcessor.CapabilityBuilder<IFluidHandler> fluid = this.capabilities.fluidHandler();
        for (CapabilityFacing i : ChemicalLogic.out) {
            ArrayFluidHandler todrain = ArrayFluidHandler.drainOnly((IFluidTank)this.inTank[num++], (Runnable)capabilitySource.getMarkDirtyRunnable());
            this.outputFluidCap.add(i.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.FLUID_HANDLER));
            fluid.addCapability(i, (IFluidHandler)todrain);
        }
        num = 0;
        for (CapabilityFacing i : ChemicalLogic.in) {
            ArrayFluidHandler tofill = ArrayFluidHandler.fillOnly((IFluidTank)this.inTank[num++], (Runnable)capabilitySource.getMarkDirtyRunnable());
            fluid.addCapability(i, (IFluidHandler)tofill);
        }
        this.outputItemCap = ChemicalLogic.itemout.getFacingCapability((ICommonMultiblockContext)capabilitySource, ForgeCapabilities.ITEM_HANDLER);
        this.capabilities.energy().addCapability(ChemicalLogic.energy, (IEnergyStorage)this.energyStorage);
    }

    public void writeSaveNBT(CompoundTag nbt) {
        nbt.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        this.recipe.writeCustomNBT(nbt, false);
        nbt.m_128365_("energy", this.energyStorage.serializeNBT());
        ListTag tanks = new ListTag();
        for (FluidTank tank : this.inTank) {
            tanks.add((Object)tank.writeToNBT(new CompoundTag()));
        }
        for (FluidTank tank : this.outTank) {
            tanks.add((Object)tank.writeToNBT(new CompoundTag()));
        }
        nbt.m_128365_("tanks", (Tag)tanks);
    }

    public void readSaveNBT(CompoundTag nbt) {
        int i;
        this.inventory.deserializeNBT(nbt.m_128469_("inv"));
        this.recipe.readCustomNBT(nbt, false);
        this.energyStorage.deserializeNBT(nbt.m_128423_("energy"));
        ListTag tanks = nbt.m_128437_("tanks", 10);
        for (i = 0; i < 3; ++i) {
            this.inTank[i].readFromNBT(tanks.m_128728_(i));
        }
        for (i = 0; i < 3; ++i) {
            this.outTank[i].readFromNBT(tanks.m_128728_(i + 3));
        }
    }

    public void writeSyncNBT(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
    }

    public void readSyncNBT(CompoundTag nbt) {
        this.active = nbt.m_128471_("active");
    }

    private static /* synthetic */ boolean lambda$new$2(Supplier level, Integer i, ItemStack r) {
        return ChemicalRecipe.isValidInput((Level)level.get(), r);
    }

    class RecipeResetFluidTank
    extends FluidTank {
        public RecipeResetFluidTank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            ChemicalState.this.recipe.onContainerChanged();
        }
    }
}

